/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.session.crypto;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;

public class Crypto {
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    public static byte[] generateNonce() {
        return Crypto.generateNonce(32);
    }

    public static byte[] generateNonce(int len) {
        SecureRandom randy = new SecureRandom();
        byte[] bytes = new byte[len];
        randy.nextBytes(bytes);
        return bytes;
    }

    public static String base64Encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] base64Decode(String str) {
        return Base64.getDecoder().decode(str);
    }

    public static String sha1StringUtf8(String str) {
        return Crypto.sha1Bytes(str.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha1Bytes(byte[] bytes) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Failed to get SHA1 digest.");
        }
        digest.update(bytes);
        byte[] hash = digest.digest();
        StringBuilder sb = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            sb.append(HEX[b >> 4 & 0xF]);
            sb.append(HEX[b & 0xF]);
        }
        return sb.toString();
    }
}

