/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.session.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import net.creeperhost.minetogether.session.crypto.PEMUtils;

public class RSAUtils {
    public static byte[] sign(String alg, byte[] bytes, PrivateKey privateKey) {
        try {
            Signature sign = Signature.getInstance(alg);
            sign.initSign(privateKey);
            sign.update(bytes);
            return sign.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new RuntimeException("Rsa not available??", ex);
        }
    }

    public static boolean isValid(String alg, byte[] payload, byte[] signature, PublicKey publicKey) {
        try {
            Signature verify = Signature.getInstance(alg);
            verify.initVerify(publicKey);
            verify.update(payload);
            return verify.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            return false;
        }
    }

    public static PrivateKey loadRSAPrivateKeyPem(Path path) throws IOException {
        return RSAUtils.loadRSAPrivateKey(PEMUtils.loadPem(path));
    }

    public static PrivateKey loadRSAPrivateKeyPem(InputStream is) throws IOException {
        return RSAUtils.loadRSAPrivateKey(PEMUtils.loadPem(is));
    }

    public static PrivateKey loadRSAPrivateKeyPem(String str) throws IOException {
        return RSAUtils.loadRSAPrivateKey(PEMUtils.loadPem(str));
    }

    public static PrivateKey loadRSAPrivateKeyPem(byte[] bytes) throws IOException {
        return RSAUtils.loadRSAPrivateKey(PEMUtils.loadPem(bytes));
    }

    public static PrivateKey loadRSAPrivateKey(byte[] key) {
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new RuntimeException("Failed to load private key.", ex);
        }
    }

    public static PublicKey loadRSAPublicKeyPem(Path path) throws IOException {
        return RSAUtils.loadRSAPublicKey(PEMUtils.loadPem(path));
    }

    public static PublicKey loadRSAPublicKeyPem(InputStream is) throws IOException {
        return RSAUtils.loadRSAPublicKey(PEMUtils.loadPem(is));
    }

    public static PublicKey loadRSAPublicKeyPem(String str) throws IOException {
        return RSAUtils.loadRSAPublicKey(PEMUtils.loadPem(str));
    }

    public static PublicKey loadRSAPublicKeyPem(byte[] bytes) throws IOException {
        return RSAUtils.loadRSAPublicKey(PEMUtils.loadPem(bytes));
    }

    public static PublicKey loadRSAPublicKey(byte[] key) {
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new RuntimeException("Failed to load public key.", ex);
        }
    }

    public static List<String> encodeRSAKey(PublicKey key) {
        return PEMUtils.writePem(key.getEncoded(), "RSA PUBLIC");
    }

    public static List<String> encodeRSAKey(PrivateKey key) {
        return PEMUtils.writePem(key.getEncoded(), "RSA PRIVATE");
    }
}

