/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.util;

import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.creeperhost.minetogether.lib.web.ApiRequest;
import net.creeperhost.minetogether.lib.web.ApiResponse;
import org.jetbrains.annotations.Nullable;

public class GetClosestDCRequest
extends ApiRequest<Response> {
    public GetClosestDCRequest() {
        super("GET", "https://www.creeperhost.net/json/datacentre/closest", (Type)((Object)Response.class));
        this.requiredAuthHeaders.add("Fingerprint");
        this.requiredAuthHeaders.add("Identifier");
    }

    public static class Response
    extends ApiResponse {
        @SerializedName(value="datacentre")
        @Nullable
        private DataCenter dataCentre;
        @Nullable
        private Customer customer;
        @SerializedName(value="datacentres")
        private List<DataCenter> dataCenters = new LinkedList<DataCenter>();

        public DataCenter getDataCenter() {
            return Objects.requireNonNull(this.dataCentre);
        }

        public Customer getCustomer() {
            return Objects.requireNonNull(this.customer);
        }

        public List<DataCenter> getDataCenters() {
            return this.dataCenters;
        }
    }

    public static class Customer {
        @Nullable
        private String country;
        @Nullable
        private String source;
        @Nullable
        private String longitude;
        @Nullable
        private String latitude;
        @Nullable
        private String ip;

        public String getCountry() {
            return Objects.requireNonNull(this.country);
        }

        public String getSource() {
            return Objects.requireNonNull(this.source);
        }

        public String getLongitude() {
            return Objects.requireNonNull(this.longitude);
        }

        public String getLatitude() {
            return Objects.requireNonNull(this.latitude);
        }

        public String getIp() {
            return Objects.requireNonNull(this.ip);
        }
    }

    public static class DataCenter {
        @Nullable
        private String name;
        @Nullable
        private Long distance;
        @Nullable
        private String longitude;
        @Nullable
        private String latitude;

        public String getName() {
            return Objects.requireNonNull(this.name);
        }

        public Long getDistance() {
            return Objects.requireNonNull(this.distance);
        }

        public String getLongitude() {
            return Objects.requireNonNull(this.longitude);
        }

        public String getLatitude() {
            return Objects.requireNonNull(this.latitude);
        }
    }
}

