/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.lib.chat.message.MessageComponent;
import net.creeperhost.minetogether.lib.chat.message.ProfileMessageComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;

public class MessageFormatter {
    public static final HoverEvent.Action<Component> SHOW_URL_PREVIEW = new HoverEvent.Action("show_url_preview", true, null, null, null);
    public static final String CLICK_NAME = "CE:CLICK_NAME";
    private static final Pattern URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);

    public static Component formatMessage(Message message) {
        ChatFormatting mc = MessageFormatter.getMessageColour(message);
        ChatFormatting ac = MessageFormatter.getArrowColour(message);
        ChatFormatting uc = MessageFormatter.getUserColour(message);
        String sender = ac + "<" + uc + message.senderName + ac + ">" + ChatFormatting.RESET;
        return Component.m_237113_((String)sender).m_130938_(e -> e.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, CLICK_NAME))).m_130946_(" ").m_7220_(MessageFormatter.formatMessage(message.getMessage(), mc));
    }

    private static Component formatMessage(MessageComponent comp, ChatFormatting messageColour) {
        MutableComponent component = Component.m_237113_((String)"").m_130940_(messageColour);
        for (MessageComponent c : comp.iterate()) {
            if (c instanceof ProfileMessageComponent) {
                ProfileMessageComponent profileComp = (ProfileMessageComponent)c;
                if (profileComp.profile == MineTogetherChat.getOurProfile()) {
                    component.m_7220_((Component)Component.m_237113_((String)c.getMessage()).m_130940_(ChatFormatting.RED));
                    continue;
                }
            }
            component.m_7220_(MessageFormatter.sugarLinkWithPreview(c.getMessage(), true, messageColour));
        }
        return component;
    }

    private static ChatFormatting getMessageColour(Message message) {
        if (message.sender != null) {
            if (message.sender.isBanned()) {
                return ChatFormatting.DARK_GRAY;
            }
            if (message.sender == MineTogetherChat.getOurProfile()) {
                return ChatFormatting.GRAY;
            }
        }
        return ChatFormatting.WHITE;
    }

    public static ChatFormatting getArrowColour(Message message) {
        if (message.sender != null) {
            if (message.sender.isPremium()) {
                return ChatFormatting.GREEN;
            }
            if (message.sender == MineTogetherChat.getOurProfile()) {
                return ChatFormatting.GRAY;
            }
        }
        return ChatFormatting.WHITE;
    }

    private static ChatFormatting getUserColour(Message message) {
        if (message.sender == null) {
            return ChatFormatting.AQUA;
        }
        boolean isOnSamePack = MineTogetherChat.getOurProfile().isOnSamePack(message.sender);
        if (message.sender.isFriend()) {
            return isOnSamePack ? ChatFormatting.GOLD : ChatFormatting.YELLOW;
        }
        if (message.sender == MineTogetherChat.getOurProfile()) {
            return ChatFormatting.GRAY;
        }
        if (isOnSamePack) {
            return ChatFormatting.DARK_PURPLE;
        }
        return ChatFormatting.WHITE;
    }

    private static Component sugarLinkWithPreview(String string, boolean allowMissingHeader, ChatFormatting messageColour) {
        MutableComponent ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            MutableComponent link;
            Object url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = Component.m_237115_((String)part).m_130940_(messageColour);
                    } else {
                        ichat.m_130946_(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = Component.m_237115_((String)url);
                try {
                    if (new URI((String)url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = Component.m_237115_((String)url);
                            continue;
                        }
                        ichat.m_130946_((String)url);
                        continue;
                    }
                    url = "http://" + (String)url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = Component.m_237115_((String)url);
                        continue;
                    }
                    ichat.m_130946_((String)url);
                    continue;
                }
            }
            ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, (String)url);
            HoverEvent hoverEvent = new HoverEvent(SHOW_URL_PREVIEW, (Object)Component.m_237115_((String)url));
            link.m_6270_(link.m_7383_().m_131142_(click).m_131144_(hoverEvent).m_131162_(Boolean.valueOf(true)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)));
            if (ichat == null) {
                ichat = Component.m_237113_((String)"");
            }
            ichat.m_7220_((Component)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = Component.m_237115_((String)end).m_130940_(messageColour);
        } else if (end.length() > 0) {
            ichat.m_7220_((Component)Component.m_237115_((String)string.substring(lastEnd)).m_130940_(messageColour));
        }
        return ichat;
    }
}

