/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.model.AvatarModel;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.common.block.block_entity.AvatarBlockEntity;
import vazkii.botania.xplat.XplatAbstractions;

public class AvatarBlockEntityRenderer
implements BlockEntityRenderer<AvatarBlockEntity> {
    private static final float[] ROTATIONS = new float[]{180.0f, 0.0f, 90.0f, 270.0f};
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/avatar.png");
    private final AvatarModel model;

    public AvatarBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new AvatarModel(context.m_173582_(BotaniaModelLayers.AVATAR));
    }

    public void render(@Nullable AvatarBlockEntity avatar, float pticks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ItemStack stack;
        ms.m_85836_();
        Direction facing = avatar != null && avatar.m_58904_() != null ? (Direction)avatar.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) : Direction.SOUTH;
        ms.m_85837_(0.5, (double)1.6f, 0.5);
        ms.m_85841_(1.0f, -1.0f, -1.0f);
        ms.m_85845_(Vector3f.f_122225_.m_122240_(ROTATIONS[Math.max(Math.min(ROTATIONS.length - 1, facing.m_122411_() - 2), 0)]));
        VertexConsumer buffer = buffers.m_6299_(this.model.m_103119_(texture));
        this.model.m_7695_(ms, buffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (avatar != null && !(stack = avatar.getItemHandler().m_8020_(0)).m_41619_()) {
            ms.m_85836_();
            float s = 0.6f;
            ms.m_85841_(s, s, s);
            ms.m_85837_(-0.5, 2.0, -0.25);
            ms.m_85845_(Vector3f.f_122223_.m_122240_(-70.0f));
            Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, light, overlay, ms, buffers, 0);
            ms.m_85849_();
            AvatarWieldable wieldable = XplatAbstractions.INSTANCE.findAvatarWieldable(stack);
            if (wieldable != null) {
                buffer = buffers.m_6299_(RenderType.m_110473_((ResourceLocation)wieldable.getOverlayResource(avatar)));
                s = 1.01f;
                ms.m_85836_();
                ms.m_85841_(s, s, s);
                ms.m_85837_(0.0, (double)-0.01f, 0.0);
                float alpha = (float)Math.sin((double)ClientTickHandler.ticksInGame / 20.0) / 2.0f + 0.5f;
                this.model.m_7695_(ms, buffer, 0xF000F0, overlay, 1.0f, 1.0f, 1.0f, alpha);
                ms.m_85849_();
            }
        }
        ms.m_85849_();
    }
}

