/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.ManaEnchanterBlockEntity;
import vazkii.botania.mixin.ItemEntityAccessor;

public class ManaEnchanterBlockEntityRenderer
implements BlockEntityRenderer<ManaEnchanterBlockEntity> {
    private ItemEntity item;

    public ManaEnchanterBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@NotNull ManaEnchanterBlockEntity enchanter, float partTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float alphaMod = 0.0f;
        if (enchanter.stage == ManaEnchanterBlockEntity.State.GATHER_MANA) {
            alphaMod = (float)Math.min(20, enchanter.stageTicks) / 20.0f;
        } else if (enchanter.stage == ManaEnchanterBlockEntity.State.RESET) {
            alphaMod = (float)(20 - enchanter.stageTicks) / 20.0f;
        } else if (enchanter.stage == ManaEnchanterBlockEntity.State.DO_ENCHANT) {
            alphaMod = 1.0f;
        }
        ms.m_85836_();
        if (!enchanter.itemToEnchant.m_41619_()) {
            if (this.item == null) {
                this.item = new ItemEntity(enchanter.m_58904_(), (double)enchanter.m_58899_().m_123341_(), (double)(enchanter.m_58899_().m_123342_() + 1), (double)enchanter.m_58899_().m_123343_(), enchanter.itemToEnchant);
            }
            ((ItemEntityAccessor)this.item).setAge(ClientTickHandler.ticksInGame);
            this.item.m_32045_(enchanter.itemToEnchant);
            ms.m_85837_(0.5, 1.25, 0.5);
            Minecraft.m_91087_().m_91290_().m_114384_((Entity)this.item, 0.0, 0.0, 0.0, 0.0f, partTicks, ms, buffers, light);
            ms.m_85837_(-0.5, -1.25, -0.5);
        }
        ms.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        ms.m_85837_(-2.0, -2.0, (double)-0.001f);
        float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + partTicks) / 8.0) + 1.0) / 5.0 + 0.4) * alphaMod;
        if (alpha > 0.0f) {
            if (enchanter.stage == ManaEnchanterBlockEntity.State.DO_ENCHANT || enchanter.stage == ManaEnchanterBlockEntity.State.RESET) {
                float ticks = (float)(enchanter.stageTicks + enchanter.stage3EndTicks) + partTicks;
                float angle = ticks * 2.0f;
                float yTranslation = Math.min(20.0f, ticks) / 20.0f * 1.15f;
                float scale = ticks < 10.0f ? 1.0f : 1.0f - Math.min(20.0f, ticks - 10.0f) / 20.0f * 0.75f;
                ms.m_85837_(2.5, 2.5, (double)(-yTranslation));
                ms.m_85841_(scale, scale, 1.0f);
                ms.m_85845_(Vector3f.f_122227_.m_122240_(angle));
                ms.m_85837_(-2.5, -2.5, 0.0);
            }
            VertexConsumer buffer = buffers.m_6299_(RenderHelper.ENCHANTER);
            RenderHelper.renderIconFullBright(ms, buffer, 0.0f, 0.0f, 5.0f, 5.0f, 0, 0, 16, 16, MiscellaneousModels.INSTANCE.enchanterOverlay.m_119204_(), 0xFFFFFF, alpha, light);
        }
        ms.m_85849_();
    }
}

