/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.flower.generating.FluidGeneratorBlockEntity;

public class HydroangeasBlockEntity
extends FluidGeneratorBlockEntity {
    public static final String TAG_PASSIVE_DECAY_TICKS = "passiveDecayTicks";
    private static final BlockPos[] OFFSETS = new BlockPos[]{new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1)};
    public static final int DECAY_TIME = 72000;
    private int passiveDecayTicks;

    public HydroangeasBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.HYDROANGEAS, pos, state, (TagKey<Fluid>)FluidTags.f_13131_, 40, 1);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.m_58904_().f_46443_ && ++this.passiveDecayTicks > 72000) {
            this.m_58904_().m_46961_(this.m_58899_(), false);
            if (Blocks.f_50036_.m_49966_().m_60710_((LevelReader)this.m_58904_(), this.m_58899_())) {
                this.m_58904_().m_46597_(this.m_58899_(), Blocks.f_50036_.m_49966_());
            }
        }
    }

    @Override
    public int getCooldownTime(boolean finishedPrevious) {
        return 0;
    }

    @Override
    public void doBurnParticles() {
        WispParticleData data = WispParticleData.wisp((float)Math.random() / 6.0f, 0.05f, 0.05f, 0.7f, 1.0f);
        this.emitParticle(data, 0.5 + Math.random() * 0.2 - 0.1, 0.55 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.0, (float)Math.random() / 60.0f, 0.0);
    }

    @Override
    public void playSound() {
        this.m_58904_().m_5594_(null, this.getEffectivePos(), SoundEvents.f_11911_, SoundSource.BLOCKS, 0.01f, 0.5f + (float)Math.random() * 0.5f);
    }

    @Override
    public int getMaxMana() {
        return 150;
    }

    @Override
    public int getColor() {
        return 5451744;
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.passiveDecayTicks = cmp.m_128451_(TAG_PASSIVE_DECAY_TICKS);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_PASSIVE_DECAY_TICKS, this.passiveDecayTicks);
    }

    @Override
    public int getGenerationDelay() {
        boolean rain = ((Biome)this.m_58904_().m_204166_(this.getEffectivePos()).m_203334_()).m_47530_() == Biome.Precipitation.RAIN && (this.m_58904_().m_46471_() || this.m_58904_().m_46470_());
        return rain ? 2 : 3;
    }

    @Override
    public boolean isOvergrowthAffected() {
        return false;
    }
}

