/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.RecipeSerializerBase;

public class ElvenTradeRecipe
implements vazkii.botania.api.recipe.ElvenTradeRecipe {
    private final ResourceLocation id;
    private final ImmutableList<ItemStack> outputs;
    private final NonNullList<Ingredient> inputs;

    public ElvenTradeRecipe(ResourceLocation id, ItemStack[] outputs, Ingredient ... inputs) {
        this.id = id;
        this.outputs = ImmutableList.copyOf((Object[])outputs);
        this.inputs = NonNullList.m_122779_();
        this.inputs.addAll(Arrays.asList(inputs));
    }

    @Override
    public Optional<List<ItemStack>> match(List<ItemStack> stacks) {
        ArrayList<Ingredient> inputsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        ArrayList<ItemStack> stacksToRemove = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            if (inputsMissing.isEmpty()) break;
            int stackIndex = -1;
            for (int i = 0; i < inputsMissing.size(); ++i) {
                Ingredient ingr = (Ingredient)inputsMissing.get(i);
                if (!ingr.test(stack)) continue;
                if (!stacksToRemove.contains(stack)) {
                    stacksToRemove.add(stack);
                }
                stackIndex = i;
                break;
            }
            if (stackIndex == -1) continue;
            inputsMissing.remove(stackIndex);
        }
        return inputsMissing.isEmpty() ? Optional.of(stacksToRemove) : Optional.empty();
    }

    @Override
    public boolean containsItem(ItemStack stack) {
        for (Ingredient input : this.inputs) {
            if (!input.test(stack)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return BotaniaRecipeTypes.ELVEN_TRADE_SERIALIZER;
    }

    @Override
    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    @NotNull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)BotaniaBlocks.alfPortal);
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public List<ItemStack> getOutputs(List<ItemStack> inputs) {
        return this.getOutputs();
    }

    public static class Serializer
    extends RecipeSerializerBase<ElvenTradeRecipe> {
        @NotNull
        public ElvenTradeRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            JsonElement output = json.get("output");
            ArrayList<ItemStack> outputStacks = new ArrayList<ItemStack>();
            if (output.isJsonArray()) {
                for (JsonElement e : output.getAsJsonArray()) {
                    JsonObject o = GsonHelper.m_13918_((JsonElement)e, (String)"output stack");
                    outputStacks.add(ShapedRecipe.m_151274_((JsonObject)o));
                }
            } else {
                JsonObject o = GsonHelper.m_13918_((JsonElement)output, (String)"output stack");
                outputStacks.add(ShapedRecipe.m_151274_((JsonObject)o));
            }
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : GsonHelper.m_13933_((JsonObject)json, (String)"ingredients")) {
                Ingredient ing = Ingredient.m_43917_((JsonElement)e);
                if (ing.m_43947_()) continue;
                inputs.add(ing);
            }
            return new ElvenTradeRecipe(id, outputStacks.toArray(new ItemStack[0]), inputs.toArray(new Ingredient[0]));
        }

        public ElvenTradeRecipe fromNetwork(@NotNull ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient[] inputs = new Ingredient[buf.m_130242_()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.m_43940_((FriendlyByteBuf)buf);
            }
            ItemStack[] outputs = new ItemStack[buf.m_130242_()];
            for (int i = 0; i < outputs.length; ++i) {
                outputs[i] = buf.m_130267_();
            }
            return new ElvenTradeRecipe(id, outputs, inputs);
        }

        public void toNetwork(FriendlyByteBuf buf, ElvenTradeRecipe recipe) {
            buf.m_130130_(recipe.m_7527_().size());
            for (Ingredient input : recipe.m_7527_()) {
                input.m_43923_(buf);
            }
            buf.m_130130_(recipe.getOutputs().size());
            for (ItemStack output : recipe.getOutputs()) {
                buf.m_130055_(output);
            }
        }
    }
}

