/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.BlockStateIngredient;
import vazkii.botania.common.crafting.BlockStateStateIngredient;
import vazkii.botania.common.crafting.BlocksStateIngredient;
import vazkii.botania.common.crafting.CompoundStateIngredient;
import vazkii.botania.common.crafting.TagExcludingStateIngredient;
import vazkii.botania.common.crafting.TagStateIngredient;
import vazkii.botania.common.helper.ItemNBTHelper;

public class StateIngredientHelper {
    public static StateIngredient of(Block block) {
        return new BlockStateIngredient(block);
    }

    public static StateIngredient of(BlockState state) {
        return new BlockStateStateIngredient(state);
    }

    public static StateIngredient of(TagKey<Block> tag) {
        return StateIngredientHelper.of(tag.f_203868_());
    }

    public static StateIngredient of(ResourceLocation id) {
        return new TagStateIngredient(id);
    }

    public static StateIngredient of(Collection<Block> blocks) {
        return new BlocksStateIngredient(blocks);
    }

    public static StateIngredient compound(Collection<StateIngredient> ingredients) {
        return new CompoundStateIngredient(ingredients);
    }

    public static StateIngredient combine(StateIngredient firstIngredient, StateIngredient secondIngredient) {
        CompoundStateIngredient compound;
        ArrayList<StateIngredient> ingredients = new ArrayList<StateIngredient>();
        if (firstIngredient instanceof CompoundStateIngredient) {
            compound = (CompoundStateIngredient)firstIngredient;
            ingredients.addAll((Collection<StateIngredient>)compound.getIngredients());
        } else {
            ingredients.add(firstIngredient);
        }
        if (secondIngredient instanceof CompoundStateIngredient) {
            compound = (CompoundStateIngredient)secondIngredient;
            ingredients.addAll((Collection<StateIngredient>)compound.getIngredients());
        } else {
            ingredients.add(secondIngredient);
        }
        return new CompoundStateIngredient(ingredients);
    }

    public static StateIngredient tagExcluding(TagKey<Block> tag, StateIngredient ... excluded) {
        return new TagExcludingStateIngredient(tag.f_203868_(), List.of(excluded));
    }

    public static StateIngredient deserialize(JsonObject object) {
        switch (GsonHelper.m_13906_((JsonObject)object, (String)"type")) {
            case "tag": {
                return new TagStateIngredient(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"tag")));
            }
            case "block": {
                return new BlockStateIngredient((Block)Registry.f_122824_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"block"))));
            }
            case "state": {
                return new BlockStateStateIngredient(StateIngredientHelper.readBlockState(object));
            }
            case "blocks": {
                ArrayList<Block> blocks = new ArrayList<Block>();
                for (JsonElement element : GsonHelper.m_13933_((JsonObject)object, (String)"blocks")) {
                    blocks.add((Block)Registry.f_122824_.m_7745_(new ResourceLocation(element.getAsString())));
                }
                return new BlocksStateIngredient(blocks);
            }
            case "tag_excluding": {
                ResourceLocation tag = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"tag"));
                ArrayList<StateIngredient> ingr = new ArrayList<StateIngredient>();
                for (JsonElement element : GsonHelper.m_13933_((JsonObject)object, (String)"exclude")) {
                    ingr.add(StateIngredientHelper.deserialize(GsonHelper.m_13918_((JsonElement)element, (String)"exclude entry")));
                }
                return new TagExcludingStateIngredient(tag, ingr);
            }
            case "compound": {
                ArrayList<StateIngredient> stateIngredients = new ArrayList<StateIngredient>();
                for (JsonElement ingredient : GsonHelper.m_13933_((JsonObject)object, (String)"ingredients")) {
                    if (!ingredient.isJsonObject()) {
                        throw new JsonParseException("Unknown ingredient in compound state ingredient: " + ingredient);
                    }
                    stateIngredients.add(StateIngredientHelper.deserialize(ingredient.getAsJsonObject()));
                }
                return new CompoundStateIngredient(stateIngredients);
            }
        }
        throw new JsonParseException("Unknown type!");
    }

    @Nullable
    public static StateIngredient tryDeserialize(JsonObject object) {
        return StateIngredientHelper.clearTheAir(StateIngredientHelper.deserialize(object));
    }

    public static StateIngredient clearTheAir(StateIngredient ingredient) {
        if (ingredient instanceof BlockStateIngredient || ingredient instanceof BlockStateStateIngredient) {
            if (ingredient.test(Blocks.f_50016_.m_49966_())) {
                return null;
            }
        } else if (ingredient instanceof BlocksStateIngredient) {
            BlocksStateIngredient sib = (BlocksStateIngredient)ingredient;
            ImmutableSet<Block> blocks = sib.blocks;
            ArrayList<Block> list = new ArrayList<Block>((Collection<Block>)blocks);
            if (list.removeIf(b -> b == Blocks.f_50016_)) {
                if (list.size() == 0) {
                    return null;
                }
                return StateIngredientHelper.of(list);
            }
        } else if (ingredient instanceof CompoundStateIngredient) {
            CompoundStateIngredient sic = (CompoundStateIngredient)ingredient;
            List<StateIngredient> newIngredients = sic.getIngredients().stream().map(StateIngredientHelper::clearTheAir).filter(Objects::nonNull).toList();
            if (newIngredients.isEmpty()) {
                return null;
            }
            return StateIngredientHelper.compound(newIngredients);
        }
        return ingredient;
    }

    public static StateIngredient read(FriendlyByteBuf buffer) {
        switch (buffer.m_130242_()) {
            case 0: {
                int count = buffer.m_130242_();
                HashSet<Block> set = new HashSet<Block>();
                for (int i = 0; i < count; ++i) {
                    int id = buffer.m_130242_();
                    Block block = (Block)Registry.f_122824_.m_7942_(id);
                    set.add(block);
                }
                return new BlocksStateIngredient(set);
            }
            case 1: {
                return new BlockStateIngredient((Block)Registry.f_122824_.m_7942_(buffer.m_130242_()));
            }
            case 2: {
                return new BlockStateStateIngredient(Block.m_49803_((int)buffer.m_130242_()));
            }
            case 3: {
                int ingredientCount = buffer.m_130242_();
                HashSet<StateIngredient> ingredientSet = new HashSet<StateIngredient>();
                for (int i = 0; i < ingredientCount; ++i) {
                    ingredientSet.add(StateIngredientHelper.read(buffer));
                }
                return new CompoundStateIngredient(ingredientSet);
            }
        }
        throw new IllegalArgumentException("Unknown input discriminator!");
    }

    public static JsonObject serializeBlockState(BlockState state) {
        CompoundTag nbt = NbtUtils.m_129202_((BlockState)state);
        ItemNBTHelper.renameTag(nbt, "Name", "name");
        ItemNBTHelper.renameTag(nbt, "Properties", "properties");
        Dynamic dyn = new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)nbt);
        return ((JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
    }

    public static BlockState readBlockState(JsonObject object) {
        CompoundTag nbt = (CompoundTag)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)object).convert((DynamicOps)NbtOps.f_128958_).getValue();
        ItemNBTHelper.renameTag(nbt, "name", "Name");
        ItemNBTHelper.renameTag(nbt, "properties", "Properties");
        String name = nbt.m_128461_("Name");
        ResourceLocation id = ResourceLocation.m_135820_((String)name);
        if (id == null || !Registry.f_122824_.m_6612_(id).isPresent()) {
            throw new IllegalArgumentException("Invalid or unknown block ID: " + name);
        }
        return NbtUtils.m_129241_((CompoundTag)nbt);
    }
}

