/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.PixieEntity;
import vazkii.botania.common.helper.ItemNBTHelper;

public class BottledManaItem
extends Item {
    public static final int SWIGS = 6;
    private static final String TAG_SWIGS_LEFT = "swigsLeft";
    private static final String TAG_SEED = "randomSeed";

    public BottledManaItem(Item.Properties props) {
        super(props);
    }

    private void effect(ItemStack stack, LivingEntity living) {
        block0 : switch (new Random(this.getSeed(stack)).nextInt(16)) {
            case 0: {
                living.m_20334_((Math.random() - 0.5) * 3.0, living.m_20184_().m_7098_(), (Math.random() - 0.5) * 3.0);
                break;
            }
            case 1: {
                if (living.m_9236_().f_46443_ || living.m_9236_().m_6042_().f_63857_()) break;
                living.m_9236_().m_46597_(living.m_20183_(), Blocks.f_49990_.m_49966_());
                break;
            }
            case 2: {
                if (living.m_9236_().f_46443_) break;
                living.m_20254_(4);
                break;
            }
            case 3: {
                if (living.m_9236_().f_46443_) break;
                living.m_9236_().m_46511_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), 0.25f, Explosion.BlockInteraction.NONE);
                break;
            }
            case 4: {
                if (living.m_9236_().m_6042_().f_63857_()) break;
                if (!living.m_9236_().f_46443_) {
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 5));
                }
                living.m_20334_(living.m_20184_().m_7096_(), 6.0, living.m_20184_().m_7094_());
                break;
            }
            case 5: {
                if (living.m_9236_().f_46443_) break;
                float nextHealth = (float)(Math.random() * (double)living.m_21233_());
                if (Mth.m_14033_((float)nextHealth, (float)0.0f)) {
                    nextHealth = 0.5f;
                }
                living.m_21153_(nextHealth);
                break;
            }
            case 6: {
                if (living.m_9236_().f_46443_) break;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 2400, 9));
                break;
            }
            case 7: {
                if (living.m_9236_().f_46443_ || !(living instanceof Player)) break;
                Player player = (Player)living;
                player.m_150109_().m_36071_();
                break;
            }
            case 8: {
                living.m_146926_((float)Math.random() * 360.0f);
                living.m_146922_((float)Math.random() * 180.0f);
                break;
            }
            case 9: {
                int x = Mth.m_14107_((double)living.m_20185_());
                int z = Mth.m_14107_((double)living.m_20189_());
                for (int i = living.m_9236_().m_151558_(); i > living.m_9236_().m_141937_(); --i) {
                    BlockState state = living.m_9236_().m_8055_(new BlockPos(x, i, z));
                    if (state.m_60795_()) continue;
                    living.m_6021_(living.m_20185_(), (double)i, living.m_20189_());
                    break block0;
                }
                break;
            }
            case 10: {
                if (living.m_9236_().f_46443_) break;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 200));
                break;
            }
            case 11: {
                if (living.m_9236_().f_46443_) break;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 6000, 0));
                break;
            }
            case 12: {
                if (living.m_9236_().f_46443_) break;
                break;
            }
            case 13: {
                if (living.m_9236_().f_46443_) break;
                PixieEntity pixie = new PixieEntity(living.m_9236_());
                pixie.m_6034_(living.m_20185_(), living.m_20186_() + 1.5, living.m_20189_());
                living.m_9236_().m_7967_((Entity)pixie);
                break;
            }
            case 14: {
                if (living.m_9236_().f_46443_) break;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 160, 3));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 160, 0));
                break;
            }
            case 15: {
                if (living.m_9236_().f_46443_ || !(living instanceof Player)) break;
                Player player = (Player)living;
                living.m_6469_(DamageSource.f_19319_, living.m_21223_() - 1.0f);
                ItemStack skull = new ItemStack((ItemLike)Items.f_42680_);
                ItemNBTHelper.setString(skull, "SkullOwner", player.m_36316_().getName());
                living.m_5552_(skull, 0.0f);
            }
        }
    }

    private long getSeed(ItemStack stack) {
        long seed = ItemNBTHelper.getLong(stack, TAG_SEED, -1L);
        if (seed == -1L) {
            return this.randomSeed(stack);
        }
        return seed;
    }

    private long randomSeed(ItemStack stack) {
        long seed = Math.abs(ThreadLocalRandom.current().nextLong());
        ItemNBTHelper.setLong(stack, TAG_SEED, seed);
        return seed;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> stacks, TooltipFlag flags) {
        stacks.add((Component)Component.m_237115_((String)"botaniamisc.bottleTooltip"));
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, Level world, LivingEntity living) {
        this.effect(stack, living);
        int left = BottledManaItem.getSwigsLeft(stack);
        if (left <= 1) {
            return new ItemStack((ItemLike)Items.f_42590_);
        }
        this.setSwigsLeft(stack, left - 1);
        this.randomSeed(stack);
        return stack;
    }

    public int m_8105_(ItemStack stack) {
        return 20;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public static int getSwigsLeft(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_SWIGS_LEFT, 6);
    }

    private void setSwigsLeft(ItemStack stack, int swigs) {
        ItemNBTHelper.setInt(stack, TAG_SWIGS_LEFT, swigs);
    }
}

