/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.client;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.BufferBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.SortedMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import vazkii.botania.api.BotaniaForgeClientCapabilities;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.client.BotaniaItemProperties;
import vazkii.botania.client.core.handler.BossBarHandler;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.client.core.handler.DebugHandler;
import vazkii.botania.client.core.handler.KonamiHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.fx.BotaniaParticles;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.client.gui.ManaBarTooltipComponent;
import vazkii.botania.client.gui.TooltipHandler;
import vazkii.botania.client.gui.bag.FlowerPouchGui;
import vazkii.botania.client.gui.box.BaubleBoxGui;
import vazkii.botania.client.integration.ears.EarsIntegration;
import vazkii.botania.client.model.BotaniaLayerDefinitions;
import vazkii.botania.client.render.BlockRenderLayers;
import vazkii.botania.client.render.ColorHandler;
import vazkii.botania.client.render.entity.EntityRenderers;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.bauble.RingOfDexterousMotionItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.forge.CapabilityUtil;
import vazkii.botania.forge.client.ForgeFloatingFlowerModel;
import vazkii.botania.mixin.client.RenderBuffersAccessor;
import vazkii.botania.xplat.ClientXplatAbstractions;
import vazkii.botania.xplat.XplatAbstractions;

@Mod.EventBusSubscriber(modid="botania", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ForgeClientInitializer {
    private static final Supplier<Map<BlockEntityType<?>, Function<BlockEntity, WandHUD>>> WAND_HUD = Suppliers.memoize(() -> {
        IdentityHashMap ret = new IdentityHashMap();
        BotaniaBlockEntities.registerWandHudCaps((factory, types) -> {
            for (BlockEntityType type : types) {
                ret.put(type, factory);
            }
        });
        BotaniaFlowerBlocks.registerWandHudCaps((factory, types) -> {
            for (BlockEntityType type : types) {
                ret.put(type, factory);
            }
        });
        return Collections.unmodifiableMap(ret);
    });
    private static final Supplier<Map<EntityType<?>, Function<Entity, WandHUD>>> ENTITY_WAND_HUD = Suppliers.memoize(() -> {
        IdentityHashMap ret = new IdentityHashMap();
        BotaniaEntities.registerWandHudCaps((factory, types) -> {
            for (EntityType type : types) {
                ret.put(type, factory);
            }
        });
        return Collections.unmodifiableMap(ret);
    });

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent e) {
        e.registerAbove(VanillaGuiOverlay.EXPERIENCE_BAR.id(), "hud", (gui, poseStack, partialTick, width, height) -> HUDHandler.onDrawScreenPost(poseStack, partialTick));
    }

    @SubscribeEvent
    public static void clientInit(FMLClientSetupEvent evt) {
        BlockRenderLayers.init(ItemBlockRenderTypes::setRenderLayer);
        evt.enqueueWork(() -> {
            MenuScreens.m_96206_(BotaniaItems.FLOWER_BAG_CONTAINER, FlowerPouchGui::new);
            MenuScreens.m_96206_(BotaniaItems.BAUBLE_BOX_CONTAINER, BaubleBoxGui::new);
        });
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(e -> KonamiHandler.renderBook(e.getBook(), e.getScreen(), e.getMouseX(), e.getMouseY(), e.getPartialTicks(), e.getPoseStack()));
        bus.addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                ClientTickHandler.clientTickEnd(Minecraft.m_91087_());
                KonamiHandler.clientTick(Minecraft.m_91087_());
            }
        });
        bus.addListener(e -> TooltipHandler.onTooltipEvent(e.getItemStack(), e.getFlags(), e.getToolTip()));
        bus.addListener(e -> CorporeaInputHandler.buttonPressed(e.getKeyCode(), e.getScanCode()));
        bus.addListener(EventPriority.HIGH, e -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && CorporeaIndexBlockEntity.ClientHandler.onChat((Player)player, e.getMessage())) {
                e.setCanceled(true);
            }
        });
        bus.addListener(e -> {
            OptionalInt result = BossBarHandler.onBarRender(e.getPoseStack(), e.getX(), e.getY(), (BossEvent)e.getBossEvent(), true);
            result.ifPresent(increment -> {
                e.setCanceled(true);
                e.setIncrement(increment);
            });
        });
        bus.addListener(e -> DebugHandler.onDrawDebugText(e.getLeft()));
        bus.addListener(e -> {
            RingOfDexterousMotionItem.ClientLogic.onKeyDown();
            KonamiHandler.handleInput(e.getKey(), e.getAction(), e.getModifiers());
        });
        bus.addListener(e -> {
            if (e.phase == TickEvent.Phase.START) {
                ClientTickHandler.renderTick(e.renderTickTime);
            }
        });
        bus.addListener(EventPriority.LOWEST, e -> {
            ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(e.getItemStack());
            if (manaItem == null) {
                return;
            }
            int width = 0;
            ManaBarTooltipComponent manaBar = null;
            for (ClientTooltipComponent component : e.getComponents()) {
                ManaBarTooltipComponent c;
                width = Math.max(width, component.m_142069_(e.getFont()));
                if (!(component instanceof ManaBarTooltipComponent)) continue;
                manaBar = c = (ManaBarTooltipComponent)component;
            }
            if (manaBar != null) {
                manaBar.setContext(e.getX(), e.getY(), width);
            }
        });
        ClientProxy.initSeasonal();
        bus.addGenericListener(Entity.class, ForgeClientInitializer::attachEntityCapabilities);
        bus.addGenericListener(BlockEntity.class, ForgeClientInitializer::attachBeCapabilities);
        if (XplatAbstractions.INSTANCE.isModLoaded("ears")) {
            EarsIntegration.register();
        }
    }

    @SubscribeEvent
    public static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent e) {
        e.register(ManaBarTooltip.class, ManaBarTooltipComponent::new);
    }

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent e) {
        ClientProxy.initKeybindings(arg_0 -> ((RegisterKeyMappingsEvent)e).register(arg_0));
    }

    private static void attachBeCapabilities(AttachCapabilitiesEvent<BlockEntity> e) {
        BlockEntity be = (BlockEntity)e.getObject();
        Function<BlockEntity, WandHUD> makeWandHud = WAND_HUD.get().get(be.m_58903_());
        if (makeWandHud != null) {
            e.addCapability(ResourceLocationHelper.prefix("wand_hud"), CapabilityUtil.makeProvider(BotaniaForgeClientCapabilities.WAND_HUD, makeWandHud.apply(be)));
        }
    }

    private static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> e) {
        Entity entity = (Entity)e.getObject();
        Function<Entity, WandHUD> makeWandHud = ENTITY_WAND_HUD.get().get(entity.m_6095_());
        if (makeWandHud != null) {
            e.addCapability(ResourceLocationHelper.prefix("wand_hud"), CapabilityUtil.makeProvider(BotaniaForgeClientCapabilities.WAND_HUD, makeWandHud.apply(entity)));
        }
    }

    @SubscribeEvent
    public static void loadComplete(FMLLoadCompleteEvent evt) {
        SortedMap<RenderType, BufferBuilder> layers = ((RenderBuffersAccessor)Minecraft.m_91087_().m_91269_()).getEntityBuilders();
        layers.put(RenderHelper.MANA_POOL_WATER, new BufferBuilder(RenderHelper.MANA_POOL_WATER.m_110507_()));
    }

    @SubscribeEvent
    public static void registerModelLoader(ModelEvent.RegisterGeometryLoaders evt) {
        evt.register(ClientXplatAbstractions.FLOATING_FLOWER_MODEL_LOADER_ID.m_135815_(), (IGeometryLoader)ForgeFloatingFlowerModel.Loader.INSTANCE);
    }

    @SubscribeEvent
    public static void onModelRegister(ModelEvent.RegisterAdditional evt) {
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        MiscellaneousModels.INSTANCE.onModelRegister(resourceManager, arg_0 -> ((ModelEvent.RegisterAdditional)evt).register(arg_0));
        BotaniaItemProperties.init((item, id, prop) -> ItemProperties.register((Item)item.m_5456_(), (ResourceLocation)id, (ItemPropertyFunction)prop));
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions evt) {
        BotaniaLayerDefinitions.init((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)evt).registerLayerDefinition(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers evt) {
        EntityRenderers.registerBlockEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerBlockEntityRenderer(arg_0, arg_1));
        EntityRenderers.registerEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerEntityRenderer(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerParticleFactories(final RegisterParticleProvidersEvent evt) {
        BotaniaParticles.FactoryHandler.registerFactories(new BotaniaParticles.FactoryHandler.Consumer(){

            @Override
            public <T extends ParticleOptions> void register(ParticleType<T> type, Function<SpriteSet, ParticleProvider<T>> constructor) {
                evt.register(type, constructor::apply);
            }
        });
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block evt) {
        ColorHandler.submitBlocks((arg_0, arg_1) -> ((RegisterColorHandlersEvent.Block)evt).register(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item evt) {
        ColorHandler.submitItems((arg_0, arg_1) -> ((RegisterColorHandlersEvent.Item)evt).register(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void initAuxiliaryRender(EntityRenderersEvent.AddLayers evt) {
        for (String playerModelType : evt.getSkins()) {
            LivingEntityRenderer livingEntityRenderer = evt.getSkin(playerModelType);
            if (!(livingEntityRenderer instanceof PlayerRenderer)) continue;
            PlayerRenderer renderer = (PlayerRenderer)livingEntityRenderer;
            EntityRenderers.addAuxiliaryPlayerRenders(renderer, arg_0 -> ((PlayerRenderer)renderer).m_115326_(arg_0));
        }
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent evt) throws IOException {
        CoreShaders.init(evt.getResourceManager(), p -> evt.registerShader((ShaderInstance)p.getFirst(), (Consumer)p.getSecond()));
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.BakingCompleted evt) {
        MiscellaneousModels.INSTANCE.onModelBake(evt.getModelBakery(), evt.getModels());
    }
}

