/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams;

import com.lootbeams.Configuration;
import com.lootbeams.LootBeamRenderer;
import com.lootbeams.LootBeams;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="lootbeams", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientSetup {
    public static void init(FMLClientSetupEvent ignored) {
        ignored.enqueueWork(() -> {
            MinecraftForge.EVENT_BUS.addListener(ClientSetup::onRenderNameplate);
            MinecraftForge.EVENT_BUS.addListener(ClientSetup::onItemCreation);
            MinecraftForge.EVENT_BUS.addListener(ClientSetup::entityRemoval);
        });
    }

    public static void onItemCreation(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity ie = (ItemEntity)entity;
            LootBeamRenderer.TOOLTIP_CACHE.computeIfAbsent(ie, itemEntity -> itemEntity.m_32055_().m_41651_(null, (TooltipFlag)TooltipFlag.Default.NORMAL));
            if (!LootBeamRenderer.LIGHT_CACHE.contains(ie)) {
                LootBeamRenderer.LIGHT_CACHE.add(ie);
            }
        }
    }

    public static void entityRemoval(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity ie = (ItemEntity)entity;
            LootBeamRenderer.TOOLTIP_CACHE.remove(ie);
            LootBeamRenderer.LIGHT_CACHE.remove(ie);
        }
    }

    public static int overrideLight(ItemEntity ie, int light) {
        if ((Boolean)Configuration.ALL_ITEMS.get() != false || (Boolean)Configuration.ONLY_EQUIPMENT.get() != false && ClientSetup.isEquipmentItem(ie.m_32055_().m_41720_()) || (Boolean)Configuration.ONLY_RARE.get() != false && LootBeamRenderer.compatRarityCheck(ie, false) || ClientSetup.isItemInRegistryList((List)Configuration.WHITELIST.get(), ie.m_32055_().m_41720_())) {
            light = 0xF00000;
        }
        return light;
    }

    public static void playDropSound(ItemEntity itemEntity) {
        WeighedSoundEvents sound;
        if (!((Boolean)Configuration.SOUND.get()).booleanValue()) {
            return;
        }
        Item item = itemEntity.m_32055_().m_41720_();
        if (((Boolean)Configuration.SOUND_ALL_ITEMS.get() != false && !ClientSetup.isItemInRegistryList((List)Configuration.BLACKLIST.get(), item) || (Boolean)Configuration.SOUND_ONLY_EQUIPMENT.get() != false && ClientSetup.isEquipmentItem(item) || (Boolean)Configuration.SOUND_ONLY_RARE.get() != false && LootBeamRenderer.compatRarityCheck(itemEntity, false) || ClientSetup.isItemInRegistryList((List)Configuration.SOUND_ONLY_WHITELIST.get(), item)) && (sound = Minecraft.m_91087_().m_91106_().m_120384_(LootBeams.LOOT_DROP)) != null && Minecraft.m_91087_().f_91073_ != null) {
            Minecraft.m_91087_().f_91073_.m_6263_((Player)Minecraft.m_91087_().f_91074_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), new SoundEvent(LootBeams.LOOT_DROP), SoundSource.AMBIENT, 0.1f * ((Double)Configuration.SOUND_VOLUME.get()).floatValue(), 1.0f);
        }
    }

    public static void onRenderNameplate(RenderNameTagEvent event) {
        boolean shouldRender;
        ItemEntity itemEntity;
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity) || Minecraft.m_91087_().f_91074_.m_20280_((Entity)(itemEntity = (ItemEntity)entity)) > Math.pow((Double)Configuration.RENDER_DISTANCE.get(), 2.0)) {
            return;
        }
        Item item = itemEntity.m_32055_().m_41720_();
        boolean bl = shouldRender = ((Boolean)Configuration.ALL_ITEMS.get() != false || (Boolean)Configuration.ONLY_EQUIPMENT.get() != false && ClientSetup.isEquipmentItem(item) || (Boolean)Configuration.ONLY_RARE.get() != false || ClientSetup.isItemInRegistryList((List)Configuration.WHITELIST.get(), itemEntity.m_32055_().m_41720_())) && !ClientSetup.isItemInRegistryList((List)Configuration.BLACKLIST.get(), itemEntity.m_32055_().m_41720_());
        if (shouldRender && (!((Boolean)Configuration.REQUIRE_ON_GROUND.get()).booleanValue() || itemEntity.m_20096_())) {
            LootBeamRenderer.renderLootBeam(event.getPoseStack(), event.getMultiBufferSource(), event.getPartialTick(), itemEntity.f_19853_.m_46467_(), itemEntity);
        }
    }

    public static boolean isEquipmentItem(Item item) {
        return item instanceof TieredItem || item instanceof ArmorItem || item instanceof ShieldItem || item instanceof BowItem || item instanceof CrossbowItem;
    }

    private static boolean isItemInRegistryList(List<String> registryNames, Item item) {
        if (registryNames.isEmpty()) {
            return false;
        }
        for (String id : registryNames.stream().filter(s -> !s.isEmpty()).toList()) {
            if (!id.contains(":") && ForgeRegistries.ITEMS.getKey((Object)item).m_135827_().equals(id)) {
                return true;
            }
            ResourceLocation itemResource = ResourceLocation.m_135820_((String)id);
            if (itemResource == null || ((Item)ForgeRegistries.ITEMS.getValue(itemResource)).m_5456_() != item.m_5456_()) continue;
            return true;
        }
        return false;
    }
}

