/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.util.helpers.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public class ElementConditionalLayered
extends ElementBase {
    protected static final IntSupplier WHITE = () -> 0xFFFFFF;
    protected ArrayList<IconWrapper> conditionalTextures = new ArrayList();

    public ElementConditionalLayered(IGuiAccess gui) {
        super(gui);
    }

    public ElementConditionalLayered(IGuiAccess gui, int posX, int posY) {
        super(gui, posX, posY);
    }

    public ElementConditionalLayered addSprite(String location, Supplier<Boolean> condition) {
        if (location == null) {
            return this;
        }
        return this.addSprite(new ResourceLocation(location), condition);
    }

    public ElementConditionalLayered addSprite(ResourceLocation location, Supplier<Boolean> condition) {
        if (!RenderHelper.textureExists(location)) {
            return this;
        }
        return this.addSprite(RenderHelper.getTexture(location), condition);
    }

    public ElementConditionalLayered addSprite(TextureAtlasSprite sprite, Supplier<Boolean> condition) {
        return this.addSprite(() -> sprite, condition);
    }

    public ElementConditionalLayered addSprite(Supplier<TextureAtlasSprite> sprite, Supplier<Boolean> condition) {
        return this.addSprite(sprite, WHITE, condition);
    }

    public ElementConditionalLayered addSprite(Supplier<TextureAtlasSprite> sprite, IntSupplier color, Supplier<Boolean> condition) {
        this.conditionalTextures.add(new IconWrapper(sprite, color, condition));
        return this;
    }

    @Override
    public void drawBackground(PoseStack matrixStack, int mouseX, int mouseY) {
        for (IconWrapper icon : this.conditionalTextures) {
            if (!icon.display.get().booleanValue()) continue;
            if (icon.color != WHITE) {
                this.gui.drawIcon(matrixStack, icon.texture.get(), icon.color.getAsInt(), this.posX(), this.posY());
                continue;
            }
            this.gui.drawIcon(matrixStack, icon.texture.get(), this.posX(), this.posY());
        }
    }

    protected static class IconWrapper {
        protected Supplier<TextureAtlasSprite> texture;
        protected IntSupplier color;
        protected Supplier<Boolean> display;

        IconWrapper(Supplier<TextureAtlasSprite> texture, IntSupplier color, Supplier<Boolean> display) {
            this.texture = texture;
            this.color = color;
            this.display = display;
        }
    }
}

