/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.capability.templates.ArcheryBowItemWrapper;
import cofh.lib.api.item.ICoFHItem;
import cofh.lib.util.Constants;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class BowItemCoFH
extends BowItem
implements ICoFHItem {
    protected int enchantability = 1;
    protected float accuracyModifier = 1.0f;
    protected float damageModifier = 1.0f;
    protected float velocityModifier = 1.0f;
    protected Supplier<CreativeModeTab> displayGroup;
    protected Supplier<Boolean> showInGroups = Constants.TRUE;
    protected String modId = "";

    public BowItemCoFH(Item.Properties builder) {
        super(builder);
    }

    public BowItemCoFH(Tier tier, Item.Properties builder) {
        super(builder);
        this.setParams(tier);
    }

    public BowItemCoFH setParams(Tier tier) {
        this.enchantability = tier.m_6601_();
        this.damageModifier = tier.m_6631_() / 4.0f;
        this.velocityModifier = tier.m_6624_() / 20.0f;
        return this;
    }

    public BowItemCoFH setParams(int enchantability, float accuracyModifier, float damageModifier, float velocityModifier) {
        this.enchantability = enchantability;
        this.accuracyModifier = accuracyModifier;
        this.damageModifier = damageModifier;
        this.velocityModifier = velocityModifier;
        return this;
    }

    public int m_6473_() {
        return this.enchantability;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ArcheryBowItemWrapper(stack, this.accuracyModifier, this.damageModifier, this.velocityModifier);
    }

    @Override
    public BowItemCoFH setDisplayGroup(Supplier<CreativeModeTab> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    @Override
    public BowItemCoFH setModId(String modId) {
        this.modId = modId;
        return this;
    }

    @Override
    public BowItemCoFH setShowInGroups(Supplier<Boolean> showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.get().booleanValue() || this.displayGroup != null && this.displayGroup.get() != null && this.displayGroup.get() != group) {
            return;
        }
        super.m_6787_(group, items);
    }

    public Collection<CreativeModeTab> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }

    public String getCreatorModId(ItemStack itemStack) {
        return this.modId == null || this.modId.isEmpty() ? super.getCreatorModId(itemStack) : this.modId;
    }
}

