/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.mixin;

import cofh.core.capability.CapabilityShieldItem;
import cofh.core.init.CoreMobEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    public abstract ItemStack m_21211_();

    @Inject(method={"canBeAffected(Lnet/minecraft/world/effect/MobEffectInstance;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelEffectApplication(MobEffectInstance effectInstance, CallbackInfoReturnable<Boolean> callback) {
        LivingEntity living = (LivingEntity)this;
        if (effectInstance.m_19544_() == CoreMobEffects.CHILLED.get() && living.m_21023_((MobEffect)CoreMobEffects.COLD_RESISTANCE.get())) {
            callback.setReturnValue((Object)false);
        }
        if (effectInstance.m_19544_() == CoreMobEffects.SHOCKED.get() && living.m_21023_((MobEffect)CoreMobEffects.LIGHTNING_RESISTANCE.get())) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(method={"canFreeze()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelFreeze(CallbackInfoReturnable<Boolean> callback) {
        LivingEntity living = (LivingEntity)this;
        if (living.m_21023_((MobEffect)CoreMobEffects.COLD_RESISTANCE.get())) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callback) {
        LivingEntity living = (LivingEntity)this;
        if (source.m_19384_()) {
            living.m_21195_((MobEffect)CoreMobEffects.CHILLED.get());
        }
        if (!source.m_19379_()) {
            if (source.m_19372_() && living.m_21023_((MobEffect)CoreMobEffects.EXPLOSION_RESISTANCE.get())) {
                callback.setReturnValue((Object)false);
            }
            if (source.m_19387_() && living.m_21023_((MobEffect)CoreMobEffects.MAGIC_RESISTANCE.get())) {
                callback.setReturnValue((Object)false);
            }
            if (source == DamageSource.f_146701_ && living.m_21023_((MobEffect)CoreMobEffects.COLD_RESISTANCE.get())) {
                callback.setReturnValue((Object)false);
            }
            if (source == DamageSource.f_19306_ && living.m_21023_((MobEffect)CoreMobEffects.LIGHTNING_RESISTANCE.get())) {
                callback.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"updateInvisibilityStatus()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void trueInvisibility(CallbackInfo callback) {
        LivingEntity living = (LivingEntity)this;
        if (living.m_21023_((MobEffect)CoreMobEffects.TRUE_INVISIBILITY.get())) {
            living.m_21218_();
            living.m_6842_(true);
            callback.cancel();
        }
    }

    @Inject(method={"isDamageSourceBlocked"}, at={@At(value="HEAD")}, cancellable=true)
    public void shield(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        this.m_21211_().getCapability(CapabilityShieldItem.SHIELD_ITEM_CAPABILITY).ifPresent(shield -> {
            LivingEntity living = (LivingEntity)this;
            cir.setReturnValue((Object)shield.canBlock(living, source));
            cir.cancel();
        });
    }
}

