/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.api.item.IInventoryContainerItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class InventoryContainerItemWrapper
implements IItemHandler,
ICapabilityProvider {
    private final LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this);
    protected final ItemStack container;
    protected final IInventoryContainerItem item;

    public InventoryContainerItemWrapper(ItemStack containerIn, IInventoryContainerItem itemIn) {
        this.container = containerIn;
        this.item = itemIn;
    }

    public int getSlots() {
        return this.item.getContainerSlots(this.container);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.item.getStackInSlot(this.container, slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.item.insertItem(this.container, slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.item.extractItem(this.container, slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.item.getSlotLimit(this.container, slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.item.isItemValid(this.container, slot, stack);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.holder);
    }
}

