/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.rolling_mill;

import com.mrh0.createaddition.blocks.rolling_mill.RollingMillBlockEntity;
import com.mrh0.createaddition.index.CABlockEntities;
import com.mrh0.createaddition.shapes.CAShapes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class RollingMillBlock
extends HorizontalKineticBlock
implements IBE<RollingMillBlockEntity> {
    public static final VoxelShape ROLLING_MILL_SHAPE = CAShapes.shape(0.0, 0.0, 0.0, 16.0, 5.0, 16.0).add(2.0, 0.0, 2.0, 14.0, 16.0, 14.0).build();

    public RollingMillBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ROLLING_MILL_SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!player.m_21120_(handIn).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, rollingMill -> {
            int slot;
            boolean emptyOutput = true;
            ItemStackHandler inv = rollingMill.outputInv;
            for (slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (!stackInSlot.m_41619_()) {
                    emptyOutput = false;
                }
                player.m_150109_().m_150079_(stackInSlot);
                inv.setStackInSlot(slot, ItemStack.f_41583_);
            }
            if (emptyOutput) {
                inv = rollingMill.inputInv;
                for (slot = 0; slot < inv.getSlots(); ++slot) {
                    player.m_150109_().m_150079_(inv.getStackInSlot(slot));
                    inv.setStackInSlot(slot, ItemStack.f_41583_);
                }
            }
            rollingMill.m_6596_();
            rollingMill.sendData();
        });
        return InteractionResult.SUCCESS;
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        if (entityIn.f_19853_.f_46443_) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (!entityIn.m_6084_()) {
            return;
        }
        RollingMillBlockEntity rollingMill = null;
        for (BlockPos pos : Iterate.hereAndBelow((BlockPos)entityIn.m_20183_())) {
            rollingMill = (RollingMillBlockEntity)this.getBlockEntity(worldIn, pos);
        }
        if (rollingMill == null) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        LazyOptional capability = rollingMill.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (!capability.isPresent()) {
            return;
        }
        ItemStack remainder = ((IItemHandler)capability.orElse((Object)new ItemStackHandler())).insertItem(0, itemEntity.m_32055_(), false);
        if (remainder.m_41619_()) {
            itemEntity.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (remainder.m_41613_() < itemEntity.m_32055_().m_41613_()) {
            itemEntity.m_32045_(remainder);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_155947_() && state.m_60734_() != newState.m_60734_()) {
            this.withBlockEntityDo((BlockGetter)worldIn, pos, te -> {
                ItemHelper.dropContents((Level)worldIn, (BlockPos)pos, (IItemHandler)te.inputInv);
                ItemHelper.dropContents((Level)worldIn, (BlockPos)pos, (IItemHandler)te.outputInv);
            });
            worldIn.m_46747_(pos);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction prefferedSide = this.getPreferredHorizontalFacing(context);
        if (prefferedSide != null) {
            return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_FACING, (Comparable)prefferedSide);
        }
        return super.m_5573_(context);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public BlockEntityType<? extends RollingMillBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CABlockEntities.ROLLING_MILL.get();
    }

    public Class<RollingMillBlockEntity> getBlockEntityClass() {
        return RollingMillBlockEntity.class;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return CABlockEntities.ROLLING_MILL.create(pos, state);
    }
}

