/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks;

import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.entities.IColdMob;
import com.mrbysco.forcecraft.registry.ForceEffects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.common.IForgeShearable;

public class ForceFluidBlock
extends LiquidBlock {
    public ForceFluidBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties properties) {
        super(supplier, properties);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityIn;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (player.m_21223_() < player.m_21233_()) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 10, ((Integer)ConfigHandler.COMMON.liquidRegenLevel.get()).intValue(), false, false));
                    if (((Boolean)ConfigHandler.COMMON.enableForceShake.get()).booleanValue()) {
                        player.m_7292_(new MobEffectInstance((MobEffect)ForceEffects.SHAKING.get(), 10, 0, false, false));
                    }
                }
            } else {
                boolean secondPassed;
                Zombie zombie;
                if (livingEntity instanceof Zombie && !(zombie = (Zombie)livingEntity).m_6162_()) {
                    zombie.m_6863_(true);
                    for (ItemStack armor : zombie.m_6168_()) {
                        zombie.m_19983_(armor.m_41777_());
                        armor.m_41774_(armor.m_41741_());
                    }
                    for (ItemStack held : zombie.m_6167_()) {
                        zombie.m_19983_(held.m_41777_());
                        held.m_41774_(held.m_41741_());
                    }
                }
                MobType creatureAttribute = livingEntity.m_6336_();
                MobCategory classification = livingEntity.getClassification(false);
                boolean bl = secondPassed = level.m_46467_() % 20L == 0L;
                if (classification == MobCategory.MONSTER) {
                    if (creatureAttribute == MobType.f_21641_ && level.m_46467_() % 10L == 0L) {
                        livingEntity.m_6469_(ForceCraft.LIQUID_FORCE_DAMAGE, 1.0f);
                    }
                } else {
                    if (level.m_46467_() % 10L == 0L) {
                        livingEntity.m_5634_(0.5f);
                    }
                    if (livingEntity instanceof IForgeShearable && secondPassed && level.m_213780_().m_188503_(10) <= 3) {
                        if (livingEntity instanceof Sheep) {
                            ((Sheep)livingEntity).m_29878_(false);
                        } else if (livingEntity instanceof IColdMob) {
                            IColdMob coldMob = (IColdMob)livingEntity;
                            coldMob.transformMob(livingEntity, level);
                        }
                    }
                }
            }
        }
    }
}

