/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capabilities;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidHandlerWrapper
implements IFluidHandler,
INBTSerializable<CompoundTag> {
    public static final String NBT_INPUT = "Input";
    public static final String NBT_OUTPUT = "Output";
    protected final FluidTank throttleTank;
    protected final FluidTank fuelTank;

    public FluidHandlerWrapper(FluidTank throttle, FluidTank fuel) {
        this.throttleTank = throttle;
        this.fuelTank = fuel;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(NBT_INPUT, (Tag)this.throttleTank.writeToNBT(new CompoundTag()));
        nbt.m_128365_(NBT_OUTPUT, (Tag)this.fuelTank.writeToNBT(new CompoundTag()));
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_(NBT_OUTPUT)) {
            this.fuelTank.readFromNBT(nbt.m_128469_(NBT_OUTPUT));
        }
        if (nbt.m_128441_(NBT_INPUT)) {
            this.throttleTank.readFromNBT(nbt.m_128469_(NBT_INPUT));
        }
    }

    public int getTanks() {
        return 2;
    }

    public FluidStack getFluidInTank(int tank) {
        return tank == 0 ? this.fuelTank.getFluid() : this.throttleTank.getFluid();
    }

    public int getTankCapacity(int tank) {
        return tank == 0 ? this.fuelTank.getCapacity() : this.throttleTank.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return tank == 0 ? this.fuelTank.isFluidValid(stack) : this.throttleTank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.fuelTank.isFluidValid(resource)) {
            return this.fuelTank.fill(resource, action);
        }
        return this.throttleTank.fill(resource, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.fuelTank.getFluid().isFluidEqual(resource)) {
            return this.fuelTank.drain(resource, action);
        }
        return this.throttleTank.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.fuelTank.getFluidAmount() > 0) {
            return this.fuelTank.drain(maxDrain, action);
        }
        return this.throttleTank.drain(maxDrain, action);
    }
}

