/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.datagen;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mrbysco.forcecraft.datagen.assets.ForceBlockModels;
import com.mrbysco.forcecraft.datagen.assets.ForceBlockStates;
import com.mrbysco.forcecraft.datagen.assets.ForceItemModels;
import com.mrbysco.forcecraft.datagen.assets.ForceLanguage;
import com.mrbysco.forcecraft.datagen.data.ForceLoot;
import com.mrbysco.forcecraft.datagen.data.ForceLootModifiers;
import com.mrbysco.forcecraft.datagen.data.ForceRecipes;
import com.mrbysco.forcecraft.datagen.data.tags.ForceBlockTags;
import com.mrbysco.forcecraft.datagen.data.tags.ForceItemTags;
import com.mrbysco.forcecraft.datagen.patchouli.PatchouliProvider;
import com.mrbysco.forcecraft.modifier.AddConfigFeatureBiomeModifier;
import com.mrbysco.forcecraft.registry.ForceEntities;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.world.feature.ForceFeatureConfigs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForceDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)RegistryAccess.m_206197_());
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_236039_(event.includeServer(), (DataProvider)new ForceLoot(generator));
            generator.m_236039_(event.includeServer(), (DataProvider)new ForceRecipes(generator));
            generator.m_236039_(event.includeServer(), (DataProvider)new PatchouliProvider(generator));
            ForceBlockTags provider = new ForceBlockTags(generator, existingFileHelper);
            generator.m_236039_(event.includeServer(), (DataProvider)provider);
            generator.m_236039_(event.includeServer(), (DataProvider)new ForceItemTags(generator, provider, existingFileHelper));
            generator.m_236039_(event.includeServer(), (DataProvider)new ForceLootModifiers(generator));
            generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"forcecraft", (RegistryOps)ops, (ResourceKey)Registry.f_194567_, ForceDataGen.getConfiguredFeatures((RegistryOps<JsonElement>)ops)));
            generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"forcecraft", (RegistryOps)ops, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, ForceDataGen.getBiomeModifiers((RegistryOps<JsonElement>)ops)));
        }
        if (event.includeClient()) {
            generator.m_236039_(event.includeClient(), (DataProvider)new ForceLanguage(generator));
            generator.m_236039_(event.includeClient(), (DataProvider)new ForceBlockModels(generator, existingFileHelper));
            generator.m_236039_(event.includeClient(), (DataProvider)new ForceBlockStates(generator, existingFileHelper));
            generator.m_236039_(event.includeClient(), (DataProvider)new ForceItemModels(generator, existingFileHelper));
        }
    }

    public static Map<ResourceLocation, PlacedFeature> getConfiguredFeatures(RegistryOps<JsonElement> ops) {
        ResourceKey forceOreFeatureKey = (ResourceKey)((ResourceKey)ForceFeatureConfigs.ORE_FORCE.m_203543_().get()).m_195975_(Registry.f_122881_).get();
        Holder forceOreFeatureHolder = ((Registry)ops.m_206826_(Registry.f_122881_).get()).m_214121_(forceOreFeatureKey);
        PlacedFeature forceOreFeature = new PlacedFeature(forceOreFeatureHolder, ForceDataGen.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-24), (VerticalAnchor)VerticalAnchor.m_158922_((int)48))));
        ResourceKey forceOreBuriedFeatureKey = (ResourceKey)((ResourceKey)ForceFeatureConfigs.ORE_FORCE_BURIED.m_203543_().get()).m_195975_(Registry.f_122881_).get();
        Holder forceOreBuriedFeatureHolder = ((Registry)ops.m_206826_(Registry.f_122881_).get()).m_214121_(forceOreBuriedFeatureKey);
        PlacedFeature forceOreBuriedFeature = new PlacedFeature(forceOreBuriedFeatureHolder, ForceDataGen.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        ResourceKey forceTreeFeatureKey = (ResourceKey)((ResourceKey)ForceFeatureConfigs.FORCE_TREE.m_203543_().get()).m_195975_(Registry.f_122881_).get();
        Holder forceTreeFeatureHolder = ((Registry)ops.m_206826_(Registry.f_122881_).get()).m_214121_(forceTreeFeatureKey);
        PlacedFeature forceTreeFeature = new PlacedFeature(forceTreeFeatureHolder, VegetationPlacements.m_195481_((PlacementModifier)RarityFilter.m_191900_((int)3), (Block)((Block)ForceRegistry.FORCE_SAPLING.get())));
        return Map.of(new ResourceLocation("forcecraft", "force_ore"), forceOreFeature, new ResourceLocation("forcecraft", "force_ore_buried"), forceOreBuriedFeature, new ResourceLocation("forcecraft", "force_tree"), forceTreeFeature);
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier modifier1, PlacementModifier modifier2) {
        return List.of(modifier1, InSquarePlacement.m_191715_(), modifier2, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
        return ForceDataGen.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), modifier);
    }

    public static Map<ResourceLocation, BiomeModifier> getBiomeModifiers(RegistryOps<JsonElement> ops) {
        HashMap<ResourceLocation, BiomeModifier> map = new HashMap<ResourceLocation, BiomeModifier>();
        HolderSet.Named overworldTag = new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), BiomeTags.f_215817_);
        AddConfigFeatureBiomeModifier addForceOre = new AddConfigFeatureBiomeModifier((HolderSet<Biome>)overworldTag, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{((Registry)ops.m_206826_(Registry.f_194567_).get()).m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)new ResourceLocation("forcecraft", "force_ore")))}), GenerationStep.Decoration.UNDERGROUND_ORES, "force_ore");
        AddConfigFeatureBiomeModifier addForceOreBuried = new AddConfigFeatureBiomeModifier((HolderSet<Biome>)overworldTag, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{((Registry)ops.m_206826_(Registry.f_194567_).get()).m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)new ResourceLocation("forcecraft", "force_ore_buried")))}), GenerationStep.Decoration.UNDERGROUND_ORES, "force_ore");
        AddConfigFeatureBiomeModifier addForceTree = new AddConfigFeatureBiomeModifier((HolderSet<Biome>)overworldTag, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{((Registry)ops.m_206826_(Registry.f_194567_).get()).m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)new ResourceLocation("forcecraft", "force_tree")))}), GenerationStep.Decoration.VEGETAL_DECORATION, "force_tree");
        ForgeBiomeModifiers.AddSpawnsBiomeModifier addChuChu = new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)overworldTag, List.of(new MobSpawnSettings.SpawnerData((EntityType)ForceEntities.RED_CHU_CHU.get(), 100, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)ForceEntities.GREEN_CHU_CHU.get(), 100, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)ForceEntities.BLUE_CHU_CHU.get(), 100, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)ForceEntities.GOLD_CHU_CHU.get(), 100, 1, 1)));
        HolderSet.Named swampTag = new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), Tags.Biomes.IS_SWAMP);
        ForgeBiomeModifiers.AddSpawnsBiomeModifier addSwampChuChu = new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)swampTag, List.of(new MobSpawnSettings.SpawnerData((EntityType)ForceEntities.RED_CHU_CHU.get(), 1, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)ForceEntities.GREEN_CHU_CHU.get(), 1, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)ForceEntities.BLUE_CHU_CHU.get(), 1, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)ForceEntities.GOLD_CHU_CHU.get(), 1, 1, 1)));
        ForgeBiomeModifiers.AddSpawnsBiomeModifier addCreeperTot = ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)overworldTag, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)ForceEntities.CREEPER_TOT.get(), 25, 1, 1));
        ForgeBiomeModifiers.AddSpawnsBiomeModifier addEnderTot = ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)overworldTag, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)ForceEntities.ENDER_TOT.get(), 5, 1, 1));
        ForgeBiomeModifiers.AddSpawnsBiomeModifier addFairy = ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)overworldTag, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)ForceEntities.FAIRY.get(), 4, 1, 2));
        map.put(new ResourceLocation("forcecraft", "add_force_ore"), addForceOre);
        map.put(new ResourceLocation("forcecraft", "add_force_ore_buried"), addForceOreBuried);
        map.put(new ResourceLocation("forcecraft", "add_force_tree"), addForceTree);
        map.put(new ResourceLocation("forcecraft", "add_chu_chu"), (BiomeModifier)addChuChu);
        map.put(new ResourceLocation("forcecraft", "add_swamp_chu_chu"), (BiomeModifier)addSwampChuChu);
        map.put(new ResourceLocation("forcecraft", "add_creeper_tot"), (BiomeModifier)addCreeperTot);
        map.put(new ResourceLocation("forcecraft", "add_ender_tot"), (BiomeModifier)addEnderTot);
        map.put(new ResourceLocation("forcecraft", "add_fairy"), (BiomeModifier)addFairy);
        return map;
    }
}

