/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.capabilities.toolmodifier.ToolModCapability;
import com.mrbysco.forcecraft.entities.ColdChickenEntity;
import com.mrbysco.forcecraft.entities.ColdCowEntity;
import com.mrbysco.forcecraft.entities.ColdPigEntity;
import com.mrbysco.forcecraft.entities.IColdMob;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class ForceShearsItem
extends ShearsItem
implements IForceChargingTool {
    private static final int SET_FIRE_TIME = 10;
    private static final int SHEARS_DMG = 238;
    private static final Item[] WOOL = new Item[]{Items.f_41937_, Items.f_41934_, Items.f_41938_, Items.f_41934_, Items.f_41935_, Items.f_41870_, Items.f_41871_, Items.f_41872_, Items.f_41873_, Items.f_41874_, Items.f_41875_, Items.f_41876_, Items.f_41877_, Items.f_41878_, Items.f_41932_, Items.f_41933_, Items.f_41935_, Items.f_41936_};

    public ForceShearsItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41503_(952));
    }

    private ItemStack getRandomWool(Level level) {
        return new ItemStack((ItemLike)WOOL[Mth.m_216271_((RandomSource)level.f_46441_, (int)0, (int)WOOL.length)]);
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity entity, InteractionHand hand) {
        boolean hasHeat;
        BlockPos pos;
        Sheep target;
        Level world = entity.f_19853_;
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        RandomSource rand = world.f_46441_;
        IToolModifier toolModifier = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (toolModifier != null && toolModifier.hasRainbow() && entity instanceof Sheep && (target = (Sheep)entity).isShearable(stack, world, pos = new BlockPos(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()))) {
            List drops = target.onSheared(playerIn, stack, world, pos, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack));
            for (int i = 0; i < drops.size(); ++i) {
                ItemEntity ent = entity.m_5552_(this.getRandomWool(world), 1.0f);
                ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.m_188501_() - rand.m_188501_()) * 0.1f), (double)(rand.m_188501_() * 0.05f), (double)((rand.m_188501_() - rand.m_188501_()) * 0.1f)));
            }
            stack.m_41622_(1, entity, e -> e.m_21190_(hand));
            return InteractionResult.SUCCESS;
        }
        boolean bl = hasHeat = toolModifier != null && toolModifier.hasHeat();
        if (!(entity instanceof IColdMob)) {
            if (entity instanceof Cow) {
                Cow originalCow = (Cow)entity;
                if (!(entity instanceof MushroomCow)) {
                    int i = 1 + rand.m_188503_(3);
                    ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                    for (int j = 0; j < i; ++j) {
                        drops.add(new ItemStack((ItemLike)Items.f_42454_, 1));
                    }
                    drops.forEach(d -> {
                        ItemEntity ent = entity.m_5552_(d, 1.0f);
                        ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.m_188501_() - rand.m_188501_()) * 0.1f), (double)(rand.m_188501_() * 0.05f), (double)((rand.m_188501_() - rand.m_188501_()) * 0.1f)));
                    });
                    entity.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
                    ColdCowEntity replacementMob = new ColdCowEntity(world, ForgeRegistries.ENTITY_TYPES.getKey((Object)originalCow.m_6095_()));
                    replacementMob.m_20359_((Entity)originalCow);
                    UUID mobUUID = replacementMob.m_20148_();
                    replacementMob.m_20361_((Entity)originalCow);
                    replacementMob.m_20084_(mobUUID);
                    originalCow.m_142687_(Entity.RemovalReason.DISCARDED);
                    world.m_7967_((Entity)replacementMob);
                    if (hasHeat) {
                        replacementMob.m_20254_(10);
                    }
                    stack.m_41622_(1, entity, e -> e.m_21190_(hand));
                    return InteractionResult.SUCCESS;
                }
            }
            if (entity instanceof Chicken) {
                Chicken originalChicken = (Chicken)entity;
                Level level = originalChicken.f_19853_;
                int i = 1 + rand.m_188503_(3);
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                for (int j = 0; j < i; ++j) {
                    drops.add(new ItemStack((ItemLike)Items.f_42402_, 1));
                }
                drops.forEach(d -> {
                    ItemEntity ent = entity.m_5552_(d, 1.0f);
                    ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.m_188501_() - rand.m_188501_()) * 0.1f), (double)(rand.m_188501_() * 0.05f), (double)((rand.m_188501_() - rand.m_188501_()) * 0.1f)));
                });
                entity.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
                ColdChickenEntity replacementMob = new ColdChickenEntity(level, ForgeRegistries.ENTITY_TYPES.getKey((Object)originalChicken.m_6095_()));
                replacementMob.m_20359_((Entity)originalChicken);
                UUID mobUUID = replacementMob.m_20148_();
                replacementMob.m_20361_((Entity)originalChicken);
                replacementMob.m_20084_(mobUUID);
                originalChicken.m_142687_(Entity.RemovalReason.DISCARDED);
                level.m_7967_((Entity)replacementMob);
                if (hasHeat) {
                    replacementMob.m_20254_(10);
                }
                stack.m_41622_(1, entity, e -> e.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            if (entity instanceof Pig) {
                Pig originalPig = (Pig)entity;
                Level level = originalPig.f_19853_;
                int i = 1 + rand.m_188503_(2);
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                for (int j = 0; j < i; ++j) {
                    drops.add(new ItemStack(hasHeat ? (ItemLike)ForceRegistry.COOKED_BACON.get() : (ItemLike)ForceRegistry.RAW_BACON.get(), 1));
                }
                drops.forEach(d -> {
                    ItemEntity ent = entity.m_5552_(d, 1.0f);
                    ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.m_188501_() - rand.m_188501_()) * 0.1f), (double)(rand.m_188501_() * 0.05f), (double)((rand.m_188501_() - rand.m_188501_()) * 0.1f)));
                });
                entity.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
                ColdPigEntity replacementMob = new ColdPigEntity(level, ForgeRegistries.ENTITY_TYPES.getKey((Object)originalPig.m_6095_()));
                replacementMob.m_20359_((Entity)originalPig);
                UUID mobUUID = replacementMob.m_20148_();
                replacementMob.m_20361_((Entity)originalPig);
                replacementMob.m_20084_(mobUUID);
                originalPig.m_142687_(Entity.RemovalReason.DISCARDED);
                level.m_7967_((Entity)replacementMob);
                if (hasHeat) {
                    replacementMob.m_20254_(10);
                }
                stack.m_41622_(1, entity, e -> e.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6880_(stack, playerIn, entity, hand);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (CapabilityHandler.CAPABILITY_TOOLMOD == null) {
            return null;
        }
        return new ToolModCapability();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lores, TooltipFlag flagIn) {
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(lores);
        ToolModCapability.attachInformation(stack, lores);
        super.m_7373_(stack, level, lores, flagIn);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.damageItem(stack, amount);
    }

    public int m_6473_() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = super.getShareTag(stack);
        IToolModifier cap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (cap != null) {
            CompoundTag shareTag = ToolModCapability.writeNBT(cap);
            nbt.m_128365_("forcecraft", (Tag)shareTag);
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt == null || !nbt.m_128441_("forcecraft")) {
            return;
        }
        IToolModifier cap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (cap != null) {
            CompoundTag shareTag = nbt.m_128469_("forcecraft");
            ToolModCapability.readNBT(cap, shareTag);
        }
        super.readShareTag(stack, nbt);
    }
}

