/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.lootmodifiers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.toolmodifier.IToolModifier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;

public class SmeltingModifier
extends LootModifier {
    public static final Supplier<Codec<SmeltingModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> SmeltingModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SmeltingModifier::new)));

    public SmeltingModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList ret = new ObjectArrayList();
        generatedLoot.forEach(stack -> ret.add((Object)SmeltingModifier.smelt(stack, context)));
        return ret;
    }

    private static ItemStack smelt(ItemStack stack, LootContext context) {
        ItemStack ctxTool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        IToolModifier toolModifierCap = (IToolModifier)ctxTool.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (toolModifierCap != null && toolModifierCap.hasHeat()) {
            return context.m_78952_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)context.m_78952_()).map(AbstractCookingRecipe::m_8043_).filter(itemStack -> !itemStack.m_41619_()).map(itemStack -> ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)(stack.m_41613_() * itemStack.m_41613_()))).orElse(stack);
        }
        return stack;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CODEC.get();
    }
}

