/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.menu;

import com.mrbysco.forcecraft.items.ForceBeltItem;
import com.mrbysco.forcecraft.menu.slot.BeltSlot;
import com.mrbysco.forcecraft.registry.ForceMenus;
import com.mrbysco.forcecraft.util.FindingUtil;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ForceBeltMenu
extends AbstractContainerMenu {
    private ItemStack heldStack;
    private IItemHandler itemHandler;

    public boolean m_6875_(Player playerIn) {
        return !playerIn.m_5833_() && !this.heldStack.m_41619_();
    }

    public static ForceBeltMenu fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        return new ForceBeltMenu(windowId, playerInventory, (IItemHandler)new ItemStackHandler(8){

            public boolean isItemValid(int slot, ItemStack stack) {
                return ForceBeltItem.filter(stack);
            }
        });
    }

    public ForceBeltMenu(int id, Inventory playerInventory, IItemHandler handler) {
        super((MenuType)ForceMenus.FORCE_BELT.get(), id);
        this.heldStack = FindingUtil.findInstanceStack(playerInventory.f_35978_, stack -> stack.m_41720_() instanceof ForceBeltItem);
        if (this.heldStack == null || this.heldStack.m_41619_()) {
            playerInventory.f_35978_.m_6915_();
            return;
        }
        int xPosC = 17;
        int yPosC = 20;
        this.itemHandler = handler;
        if (this.itemHandler != null) {
            for (int k = 0; k < 8; ++k) {
                this.m_38897_((Slot)new BeltSlot(this.itemHandler, k, xPosC + k * 18, yPosC));
            }
            int xPos = 8;
            int yPos = 54;
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.m_38897_(new Slot((Container)playerInventory, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
                }
            }
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x, xPos + x * 18, yPos + 58));
            }
        } else {
            playerInventory.f_35978_.m_6915_();
        }
    }

    public void m_6877_(Player playerIn) {
        if (this.itemHandler != null) {
            CompoundTag tag = this.heldStack.m_41784_();
            tag.m_128405_("SlotsUsed", ItemHandlerUtils.getUsedSlots(this.itemHandler));
            tag.m_128405_("SlotsTotal", this.itemHandler.getSlots());
            this.heldStack.m_41751_(tag);
        }
        super.m_6877_(playerIn);
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 0 && this.m_38853_(slotId).m_7993_().m_41720_() instanceof ForceBeltItem) {
            return;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (itemstack.m_41720_() instanceof ForceBeltItem) {
                return ItemStack.f_41583_;
            }
            int containerSlots = this.f_38839_.size() - player.m_150109_().f_35974_.size();
            if (index < containerSlots ? !this.m_38903_(itemstack1, containerSlots, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, containerSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }
}

