/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.config;

import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.EnumValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringListValue;
import java.util.List;
import ky.someone.mods.gag.entity.FishingDynamiteEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;

public interface GAGConfig {
    public static final SNBTConfig CONFIG = (SNBTConfig)SNBTConfig.create((String)"gag").comment(new String[]{"Config for GAG", "If you're a modpack maker, use the defaultconfigs folder instead!"});

    private static int seconds(int i) {
        return i * 20;
    }

    public static SNBTConfig init() {
        SandsOfTime.init();
        EscapeRope.init();
        Hearthstone.init();
        Miscellaneous.init();
        Dynamite.init();
        return CONFIG;
    }

    public static interface SandsOfTime {
        public static final SNBTConfig GROUP = (SNBTConfig)CONFIG.getGroup("sands_of_time").comment(new String[]{"Settings related to the Sands Of Time mechanic", "(You can also selectively disable this mechanic for certain block entities using the gag:do_not_accelerate tag)"});
        public static final IntValue POUCH_CAPACITY = (IntValue)GROUP.getInt("pouchCapacity", Integer.MAX_VALUE, 0, Integer.MAX_VALUE).comment(new String[]{"Max amount of grains a Pouch can hold"});
        public static final StringListValue LEVEL_FILTER = (StringListValue)GROUP.getStringList("levelFilter", List.of()).comment(new String[]{"List of levels that the Sands Of Time mechanic will not work in"});
        public static final BooleanValue INVERT_LEVEL_FILTER = (BooleanValue)GROUP.getBoolean("invertLevelFilter", false).comment(new String[]{"If true, the Sands Of Time mechanic will instead *only* work in the levels specified in the levelFilter list"});
        public static final IntValue GRAINS_PER_SAND = (IntValue)GROUP.getInt("grainsPerSand", 32, 1, Integer.MAX_VALUE).comment(new String[]{"[NYI] Amount of grains one Sand Of Time yields"});
        public static final IntValue GRAINS_USED = (IntValue)GROUP.getInt("grainsUsed", 600, 1, Integer.MAX_VALUE).comment(new String[]{"Amount of grains used per click of the Temporal Pouch"}).comment(new String[]{"(Since the actual sands are NYI, this is currently just equivalent to the 'ticks' used per click)"});
        public static final IntValue DURATION_PER_USE = (IntValue)GROUP.getInt("durationPerUse", 30, 1, 60).comment(new String[]{"Time (in seconds) that a block is accelerated per use, default is 30 seconds", "This determines the 'worth' of grains as displayed in the Pouch's tooltip"});
        public static final IntValue MAX_RATE = (IntValue)GROUP.getInt("maxRate", 8, 1, 16).comment(new String[]{"Maximum times the Temporal Pouch can be used in a row, corresponding to maximum speed, default is max speed of 2^8 = x256"});
        public static final BooleanValue ALLOW_RANDOM_TICKS = (BooleanValue)GROUP.getBoolean("allowRandomTicks", true).comment(new String[]{"Whether the Temporal Pouch is allowed to accelerate random ticks"});
        public static final IntValue RANDOM_TICK_CHANCE = (IntValue)GROUP.getInt("randomTickChance", 4096, 256, 65536).comment(new String[]{"Chance that a random tick will be performed when a random ticking block like crops or saplings is accelerated", "On average, this is done every 4096 / 3 \u2248 1365.33 ticks in Vanilla (see https://minecraft.gamepedia.com/Tick#Random_tick)", "Actual value is (config value) / (random tick game rule)"});

        public static boolean isLevelAllowed(Level level) {
            String dim = level.m_46472_().m_135782_().toString();
            return ((List)LEVEL_FILTER.get()).contains(dim) == ((Boolean)INVERT_LEVEL_FILTER.get()).booleanValue();
        }

        public static void init() {
        }
    }

    public static interface EscapeRope {
        public static final SNBTConfig GROUP = (SNBTConfig)CONFIG.getGroup("escape_rope").comment(new String[]{"Settings related to the Escape Rope"});
        public static final IntValue DURABILITY = (IntValue)GROUP.getInt("durability", 512, 0, Short.MAX_VALUE).comment(new String[]{"Maximum durability of the rope, default is 512"});
        public static final IntValue WARMUP = (IntValue)GROUP.getInt("warmup", GAGConfig.seconds(3), 0, 72000).comment(new String[]{"Time (in ticks) it takes to use the rope, default is 3 seconds"});
        public static final IntValue COOLDOWN = (IntValue)GROUP.getInt("cooldown", GAGConfig.seconds(10), 0, 72000).comment(new String[]{"Time (in ticks) the player has to wait after using the rope, default is 10 seconds"});

        public static void init() {
        }
    }

    public static interface Hearthstone {
        public static final SNBTConfig GROUP = (SNBTConfig)CONFIG.getGroup("hearthstone").comment(new String[]{"Settings related to the Hearthstone"});
        public static final IntValue DURABILITY = (IntValue)GROUP.getInt("durability", 64, 0, Short.MAX_VALUE).comment(new String[]{"Maximum durability of the stone, default is 64"});
        public static final IntValue ENERGIZED_DURABILITY = (IntValue)GROUP.getInt("energizedDurability", 256, 0, Short.MAX_VALUE).comment(new String[]{"Maximum durability of the energized hearthstone, default is 256"});
        public static final IntValue RANGE = (IntValue)GROUP.getInt("range", -1).comment(new String[]{"Maximum range of the stone, set to -1 for unlimited range"});
        public static final IntValue DIMENSION_MULTIPLIER = (IntValue)GROUP.getInt("dimensionMultiplier", 2).comment(new String[]{"Damage multiplier for using the stone across dimensions, default is 2"}).comment(new String[]{"Set to -1 to disable teleporting across dimensions"});
        public static final IntValue WARMUP = (IntValue)GROUP.getInt("warmup", GAGConfig.seconds(5), 0, 72000).comment(new String[]{"Time (in ticks) it takes to use the stone, default is 5 seconds"});
        public static final IntValue COOLDOWN = (IntValue)GROUP.getInt("cooldown", GAGConfig.seconds(60), 0, 72000).comment(new String[]{"Time (in ticks) the player has to wait after using the stone, default is 60 seconds"});
        public static final BooleanValue ALLOW_SPAWN = (BooleanValue)GROUP.getBoolean("allowSpawn", true).comment(new String[]{"Whether the stone should teleport a player to the spawn point if they have no respawn point"});
        public static final BooleanValue USE_ANCHOR_CHARGE = (BooleanValue)GROUP.getBoolean("useAnchorCharge", true).comment(new String[]{"Whether the stone should use a charge on the player's respawn anchor, if applicable"});
        public static final BooleanValue IGNORE_SPAWN_BLOCK = (BooleanValue)GROUP.getBoolean("ignoreSpawnBlock", false).comment(new String[]{"Whether the stone should ignore checking whether the spawn block is still valid and unobstructed"});

        public static void init() {
        }
    }

    public static interface Miscellaneous {
        public static final SNBTConfig GROUP = (SNBTConfig)CONFIG.getGroup("misc").comment(new String[]{"Settings related to miscellaneous items and features"});
        public static final IntValue NO_SOLICITORS_RADIUS = (IntValue)GROUP.getInt("noSolicitorsRadius", 64, 1, 512).comment(new String[]{"Radius (in blocks) in which the 'No Solicitors!' sign will stop Wandering Traders from spawning, default is 32"});

        public static void init() {
        }
    }

    public static interface Dynamite {
        public static final SNBTConfig GROUP = (SNBTConfig)CONFIG.getGroup("dynamite").comment(new String[]{"Settings related to dynamite"});
        public static final IntValue MINING_RADIUS = (IntValue)GROUP.getInt("miningRadius", 7, 1, 64).comment(new String[]{"Radius (in blocks) of the Mining Dynamite's explosion, default is 7"});
        public static final BooleanValue MINING_GIVES_HASTE = (BooleanValue)GROUP.getBoolean("miningGivesHaste", true).comment(new String[]{"Controls whether the Mining Dynamite should give the Haste status effect if it hits a player"});
        public static final IntValue FISHING_RADIUS = (IntValue)GROUP.getInt("fishingRadius", 4, 1, 64).comment(new String[]{"Radius (in blocks) of the Fishing Dynamite's explosion, default is 4"});
        public static final BooleanValue FISHING_INSTAKILL_FISH = (BooleanValue)GROUP.getBoolean("fishingInstakillFish", true).comment(new String[]{"Controls whether the Fishing Dynamite should instakill fish"}).comment(new String[]{"If false, the Fishing Dynamite will instead deal 2x damage to fish"});
        public static final BooleanValue FISHING_DAMAGE_ALL = (BooleanValue)GROUP.getBoolean("fishingDamageAll", true).comment(new String[]{"Controls whether the Fishing Dynamite should deal damage to all entities, or only to fish"});
        public static final EnumValue<TargetFilter> FISHING_TARGET_FILTER = (EnumValue)GROUP.getEnum("fishingTargetFilter", TargetFilter.MAP).comment(new String[]{"Controls what entities the Fishing Dynamite should target as fish"}).comment(new String[]{"Valid values are: tag, water_animal, abstract_fish, hybrid (default)"}).comment(new String[]{"tag: Only entities with the 'gag:fishing_dynamite_fish' tag will be targeted, this includes all vanilla fish by default"}).comment(new String[]{"water_animal: Only entities that are instances of WaterAnimal will be targeted, note this *will* also include dolphins and other water animals!"}).comment(new String[]{"abstract_fish: Only entities that are instances of AbstractFish will be targeted, this might not work with some modded fish that do not extend AbstractFish"}).comment(new String[]{"hybrid: Combines the abstract_fish check with the tag filter, this is the default value since it should be the most reliable"});
        public static final IntValue ADDITIONAL_FISHING_LOOT = (IntValue)GROUP.getInt("fishingAdditionalLoot", 5, 0, 16).comment(new String[]{"Describes the amount of additional fish (generated from the vanilla loot table) that may be dropped by Fishing Dynamite"}).comment(new String[]{"(This value is random and biased towards dropping less the more fish were already hit by the explosion)"});

        public static void init() {
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum TargetFilter {
            TAG{

                @Override
                public boolean isFish(Entity entity) {
                    return entity.m_6095_().m_204039_(FishingDynamiteEntity.FISH_TAG);
                }
            }
            ,
            WATER_ANIMAL{

                @Override
                public boolean isFish(Entity entity) {
                    return entity instanceof WaterAnimal;
                }
            }
            ,
            ABSTRACT_FISH{

                @Override
                public boolean isFish(Entity entity) {
                    return entity instanceof AbstractFish;
                }
            }
            ,
            HYBRID{

                @Override
                public boolean isFish(Entity entity) {
                    return TAG.isFish(entity) || ABSTRACT_FISH.isFish(entity);
                }
            };

            public static final NameMap<TargetFilter> MAP;

            public abstract boolean isFish(Entity var1);

            static {
                MAP = NameMap.of((Object)((Object)HYBRID), (Object[])TargetFilter.values()).create();
            }
        }
    }
}

