/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.refinedmods.refinedstorage.api.render.IElementDrawers;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.util.RenderUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCraftingMonitorElement
implements ICraftingMonitorElement {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "item");
    private static final int COLOR_PROCESSING = -2494985;
    private static final int COLOR_MISSING = -860450;
    private static final int COLOR_SCHEDULED = -1514038;
    private static final int COLOR_CRAFTING = -5383226;
    private final ItemStack stack;
    private int stored;
    private int missing;
    private int processing;
    private int scheduled;
    private int crafting;

    public ItemCraftingMonitorElement(ItemStack stack, int stored, int missing, int processing, int scheduled, int crafting) {
        this.stack = stack;
        this.stored = stored;
        this.missing = missing;
        this.processing = processing;
        this.scheduled = scheduled;
        this.crafting = crafting;
    }

    public static ItemCraftingMonitorElement read(FriendlyByteBuf buf) {
        return new ItemCraftingMonitorElement(StackUtils.readItemStack(buf), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack poseStack, int x, int y, IElementDrawers drawers) {
        if (this.missing > 0) {
            drawers.getOverlayDrawer().draw(poseStack, x, y, -860450);
        } else if (this.processing > 0) {
            drawers.getOverlayDrawer().draw(poseStack, x, y, -2494985);
        } else if (this.scheduled > 0) {
            drawers.getOverlayDrawer().draw(poseStack, x, y, -1514038);
        } else if (this.crafting > 0) {
            drawers.getOverlayDrawer().draw(poseStack, x, y, -5383226);
        }
        drawers.getItemDrawer().draw(poseStack, x + 4, y + 6, this.stack);
        float scale = Minecraft.m_91087_().m_91390_() ? 1.0f : 0.5f;
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        int yy = y + 7;
        if (this.stored > 0) {
            drawers.getStringDrawer().draw(poseStack, RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy, scale), I18n.m_118938_((String)"gui.refinedstorage.crafting_monitor.stored", (Object[])new Object[]{this.stored}));
            yy += 7;
        }
        if (this.missing > 0) {
            drawers.getStringDrawer().draw(poseStack, RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy, scale), I18n.m_118938_((String)"gui.refinedstorage.crafting_monitor.missing", (Object[])new Object[]{this.missing}));
            yy += 7;
        }
        if (this.processing > 0) {
            drawers.getStringDrawer().draw(poseStack, RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy, scale), I18n.m_118938_((String)"gui.refinedstorage.crafting_monitor.processing", (Object[])new Object[]{this.processing}));
            yy += 7;
        }
        if (this.scheduled > 0) {
            drawers.getStringDrawer().draw(poseStack, RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy, scale), I18n.m_118938_((String)"gui.refinedstorage.crafting_monitor.scheduled", (Object[])new Object[]{this.scheduled}));
            yy += 7;
        }
        if (this.crafting > 0) {
            drawers.getStringDrawer().draw(poseStack, RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy, scale), I18n.m_118938_((String)"gui.refinedstorage.crafting_monitor.crafting", (Object[])new Object[]{this.crafting}));
        }
        poseStack.m_85849_();
    }

    @Override
    public ResourceLocation getBaseId() {
        return ID;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    @Nullable
    public List<Component> getTooltip() {
        return RenderUtils.getTooltipFromItem(this.stack);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        StackUtils.writeItemStack(buf, this.stack);
        buf.writeInt(this.stored);
        buf.writeInt(this.missing);
        buf.writeInt(this.processing);
        buf.writeInt(this.scheduled);
        buf.writeInt(this.crafting);
    }

    @Override
    public boolean merge(ICraftingMonitorElement element) {
        if (element.getId().equals((Object)this.getId()) && this.elementHashCode() == element.elementHashCode()) {
            this.stored += ((ItemCraftingMonitorElement)element).stored;
            this.missing += ((ItemCraftingMonitorElement)element).missing;
            this.processing += ((ItemCraftingMonitorElement)element).processing;
            this.scheduled += ((ItemCraftingMonitorElement)element).scheduled;
            this.crafting += ((ItemCraftingMonitorElement)element).crafting;
            return true;
        }
        return false;
    }

    @Override
    public int baseElementHashCode() {
        return this.elementHashCode();
    }

    @Override
    public int elementHashCode() {
        return API.instance().getItemStackHashCode(this.stack);
    }

    public static class Builder {
        private final ItemStack stack;
        private int stored;
        private int missing;
        private int processing;
        private int scheduled;
        private int crafting;

        public Builder(ItemStack stack) {
            this.stack = stack;
        }

        public static Builder forStack(ItemStack stack) {
            return new Builder(stack);
        }

        public Builder stored(int stored) {
            this.stored = stored;
            return this;
        }

        public Builder missing(int missing) {
            this.missing = missing;
            return this;
        }

        public Builder processing(int processing) {
            this.processing = processing;
            return this;
        }

        public Builder scheduled(int scheduled) {
            this.scheduled = scheduled;
            return this;
        }

        public Builder crafting(int crafting) {
            this.crafting = crafting;
            return this;
        }

        public ItemCraftingMonitorElement build() {
            return new ItemCraftingMonitorElement(this.stack, this.stored, this.missing, this.processing, this.scheduled, this.crafting);
        }
    }
}

