/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.IGridTab;
import com.refinedmods.refinedstorage.api.network.grid.INetworkAwareGrid;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IFilter;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.AllowedTagList;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.listener.FluidGridStorageCacheListener;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.listener.ItemGridStorageCacheListener;
import com.refinedmods.refinedstorage.block.GridBlock;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationManager;
import com.refinedmods.refinedstorage.blockentity.grid.GridBlockEntity;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.FilterItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.ItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.PatternItem;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class GridNetworkNode
extends NetworkNode
implements INetworkAwareGrid,
IType {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "grid");
    public static final ResourceLocation CRAFTING_ID = new ResourceLocation("refinedstorage", "crafting_grid");
    public static final ResourceLocation PATTERN_ID = new ResourceLocation("refinedstorage", "pattern_grid");
    public static final ResourceLocation FLUID_ID = new ResourceLocation("refinedstorage", "fluid_grid");
    public static final String NBT_VIEW_TYPE = "ViewType";
    public static final String NBT_SORTING_DIRECTION = "SortingDirection";
    public static final String NBT_SORTING_TYPE = "SortingType";
    public static final String NBT_SEARCH_BOX_MODE = "SearchBoxMode";
    public static final String NBT_TAB_SELECTED = "TabSelected";
    public static final String NBT_TAB_PAGE = "TabPage";
    public static final String NBT_SIZE = "Size";
    public static final int PROCESSING_MATRIX_SIZE = 81;
    private static final String NBT_EXACT_MODE = "Exact";
    private static final String NBT_PROCESSING_PATTERN = "ProcessingPattern";
    private static final String NBT_PROCESSING_TYPE = "ProcessingType";
    private static final String NBT_PROCESSING_MATRIX_FLUIDS = "ProcessingMatrixFluids";
    private static final String NBT_ALLOWED_TAGS = "AllowedTags";
    private final AllowedTagList allowedTagList = new AllowedTagList(this::updateAllowedTags, 81);
    private final ResultContainer result = new ResultContainer();
    private final BaseItemHandler processingMatrix = new BaseItemHandler(162).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        if (!reading && slot < 81) {
            this.allowedTagList.clearItemTags(slot);
        }
    });
    private final AbstractContainerMenu craftingContainer = new AbstractContainerMenu(MenuType.f_39968_, 0){

        public boolean m_6875_(Player player) {
            return false;
        }

        public ItemStack m_7648_(Player p_38941_, int p_38942_) {
            return ItemStack.f_41583_;
        }

        public void m_6199_(Container inventory) {
            if (!GridNetworkNode.this.level.f_46443_) {
                GridNetworkNode.this.onCraftingMatrixChanged();
            }
        }
    };
    private final FluidInventory processingMatrixFluids = new FluidInventory(162, 64000).addListener(new NetworkNodeFluidInventoryListener(this)).addListener((handler, slot, reading) -> {
        if (!reading && slot < 81) {
            this.allowedTagList.clearFluidTags(slot);
        }
    });
    private final Set<ICraftingGridListener> craftingListeners = new HashSet<ICraftingGridListener>();
    private final List<IFilter> filters = new ArrayList<IFilter>();
    private final CraftingContainer matrix = new CraftingContainer(this.craftingContainer, 3, 3);
    private final List<IGridTab> tabs = new ArrayList<IGridTab>();
    private final FilterItemHandler filter = (FilterItemHandler)new FilterItemHandler(this.filters, this.tabs).addListener(new NetworkNodeInventoryListener(this));
    private final GridType type;
    private CraftingRecipe currentRecipe;
    private boolean readingInventory;
    private int viewType = 0;
    private int sortingDirection = 1;
    private final BaseItemHandler patterns = new BaseItemHandler(2){

        public int getSlotLimit(int slot) {
            return slot == 1 ? 1 : super.getSlotLimit(slot);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot == 0 || stack.m_41783_() != null) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    }.addValidator(new ItemValidator((Item)RSItems.PATTERN.get())).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        ItemStack pattern = handler.getStackInSlot(slot);
        if (!reading && slot == 1 && !pattern.m_41619_()) {
            boolean processing = PatternItem.isProcessing(pattern);
            if (processing) {
                for (int i = 0; i < 81; ++i) {
                    this.processingMatrix.setStackInSlot(i, PatternItem.getInputSlot(pattern, i));
                    this.processingMatrixFluids.setFluid(i, PatternItem.getFluidInputSlot(pattern, i));
                    this.processingMatrix.setStackInSlot(81 + i, PatternItem.getOutputSlot(pattern, i));
                    this.processingMatrixFluids.setFluid(81 + i, PatternItem.getFluidOutputSlot(pattern, i));
                }
                AllowedTagList allowedTagsFromPattern = PatternItem.getAllowedTags(pattern);
                if (allowedTagsFromPattern != null) {
                    this.allowedTagList.setAllowedItemTags(allowedTagsFromPattern.getAllowedItemTags());
                    this.allowedTagList.setAllowedFluidTags(allowedTagsFromPattern.getAllowedFluidTags());
                }
            } else {
                for (int i = 0; i < 9; ++i) {
                    this.matrix.m_6836_(i, PatternItem.getInputSlot(pattern, i));
                }
            }
            this.setProcessingPattern(processing);
            this.markDirty();
        }
    });
    private int sortingType = 0;
    private int searchBoxMode = 0;
    private int size = 0;
    private int tabSelected = -1;
    private int tabPage = 0;
    private boolean exactPattern = true;
    private boolean processingPattern = false;
    private int processingType = 0;

    public GridNetworkNode(Level level, BlockPos pos, GridType type) {
        super(level, pos);
        this.type = type;
    }

    public static ResourceLocation getId(GridType type) {
        switch (type) {
            case NORMAL: {
                return ID;
            }
            case CRAFTING: {
                return CRAFTING_ID;
            }
            case PATTERN: {
                return PATTERN_ID;
            }
            case FLUID: {
                return FLUID_ID;
            }
        }
        throw new IllegalArgumentException("Unknown grid type " + type);
    }

    public AllowedTagList getAllowedTagList() {
        return this.allowedTagList;
    }

    private void updateAllowedTags() {
        this.markDirty();
        BlockEntity blockEntity = this.level.m_7702_(this.pos);
        if (blockEntity instanceof GridBlockEntity) {
            ((GridBlockEntity)blockEntity).getDataManager().sendParameterToWatchers(GridBlockEntity.ALLOWED_ITEM_TAGS);
            ((GridBlockEntity)blockEntity).getDataManager().sendParameterToWatchers(GridBlockEntity.ALLOWED_FLUID_TAGS);
        }
    }

    @Override
    public int getEnergyUsage() {
        switch (this.type) {
            case NORMAL: {
                return RS.SERVER_CONFIG.getGrid().getGridUsage();
            }
            case CRAFTING: {
                return RS.SERVER_CONFIG.getGrid().getCraftingGridUsage();
            }
            case PATTERN: {
                return RS.SERVER_CONFIG.getGrid().getPatternGridUsage();
            }
            case FLUID: {
                return RS.SERVER_CONFIG.getGrid().getFluidGridUsage();
            }
        }
        return 0;
    }

    public boolean isExactPattern() {
        return this.exactPattern;
    }

    public void setExactPattern(boolean exactPattern) {
        this.exactPattern = exactPattern;
    }

    public boolean isProcessingPattern() {
        return this.level.f_46443_ ? GridBlockEntity.PROCESSING_PATTERN.getValue() : this.processingPattern;
    }

    public void setProcessingPattern(boolean processingPattern) {
        this.processingPattern = processingPattern;
    }

    @Override
    public GridType getGridType() {
        return this.type;
    }

    @Override
    public IStorageCacheListener createListener(ServerPlayer player) {
        return this.type == GridType.FLUID ? new FluidGridStorageCacheListener(player, this.network) : new ItemGridStorageCacheListener(player, this.network);
    }

    @Override
    @Nullable
    public IStorageCache getStorageCache() {
        if (this.network != null) {
            return this.type == GridType.FLUID ? this.network.getFluidStorageCache() : this.network.getItemStorageCache();
        }
        return null;
    }

    @Override
    @Nullable
    public IItemGridHandler getItemHandler() {
        return this.network != null ? this.network.getItemGridHandler() : null;
    }

    @Override
    @Nullable
    public IFluidGridHandler getFluidHandler() {
        return this.network != null ? this.network.getFluidGridHandler() : null;
    }

    @Override
    public void addCraftingListener(ICraftingGridListener listener) {
        this.craftingListeners.add(listener);
    }

    @Override
    public void removeCraftingListener(ICraftingGridListener listener) {
        this.craftingListeners.remove(listener);
    }

    @Override
    public Component getTitle() {
        switch (this.type) {
            case CRAFTING: {
                return Component.m_237115_((String)"gui.refinedstorage.crafting_grid");
            }
            case PATTERN: {
                return Component.m_237115_((String)"gui.refinedstorage.pattern_grid");
            }
            case FLUID: {
                return Component.m_237115_((String)"gui.refinedstorage.fluid_grid");
            }
        }
        return Component.m_237115_((String)"gui.refinedstorage.grid");
    }

    public IItemHandler getPatterns() {
        return this.patterns;
    }

    @Override
    public IItemHandlerModifiable getFilter() {
        return this.filter;
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<IGridTab> getTabs() {
        return this.tabs;
    }

    @Override
    public CraftingContainer getCraftingMatrix() {
        return this.matrix;
    }

    @Override
    public ResultContainer getCraftingResult() {
        return this.result;
    }

    public BaseItemHandler getProcessingMatrix() {
        return this.processingMatrix;
    }

    public FluidInventory getProcessingMatrixFluids() {
        return this.processingMatrixFluids;
    }

    @Override
    public void onCraftingMatrixChanged() {
        if (this.currentRecipe == null || !this.currentRecipe.m_5818_((Container)this.matrix, this.level)) {
            this.currentRecipe = this.level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.matrix, this.level).orElse(null);
        }
        if (this.currentRecipe == null) {
            this.result.m_6836_(0, ItemStack.f_41583_);
        } else {
            this.result.m_6836_(0, this.currentRecipe.m_5874_((Container)this.matrix));
        }
        this.craftingListeners.forEach(ICraftingGridListener::onCraftingMatrixChanged);
        if (!this.readingInventory) {
            this.markDirty();
        }
    }

    @Override
    public void onRecipeTransfer(Player player, ItemStack[][] recipe) {
        API.instance().getCraftingGridBehavior().onRecipeTransfer(this, player, recipe);
    }

    public void clearMatrix() {
        int i;
        for (i = 0; i < this.processingMatrix.getSlots(); ++i) {
            this.processingMatrix.setStackInSlot(i, ItemStack.f_41583_);
        }
        for (i = 0; i < this.processingMatrixFluids.getSlots(); ++i) {
            this.processingMatrixFluids.setFluid(i, FluidStack.EMPTY);
        }
        for (i = 0; i < this.matrix.m_6643_(); ++i) {
            this.matrix.m_6836_(i, ItemStack.f_41583_);
        }
    }

    @Override
    public void onClosed(Player player) {
    }

    @Override
    public boolean isGridActive() {
        BlockState state = this.level.m_8055_(this.pos);
        if (state.m_60734_() instanceof GridBlock) {
            return (Boolean)state.m_61143_((Property)NetworkNodeBlock.CONNECTED);
        }
        return false;
    }

    @Override
    public int getSlotId() {
        return -1;
    }

    @Override
    public void onCrafted(Player player, @Nullable IStackList<ItemStack> availableItems, @Nullable IStackList<ItemStack> usedItems) {
        API.instance().getCraftingGridBehavior().onCrafted(this, this.currentRecipe, player, availableItems, usedItems);
    }

    @Override
    public void onClear(Player player) {
        if (this.type == GridType.CRAFTING) {
            if (this.network != null && this.network.canRun() && this.network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
                for (int i = 0; i < this.matrix.m_6643_(); ++i) {
                    ItemStack slot = this.matrix.m_8020_(i);
                    if (slot.m_41619_()) continue;
                    this.matrix.m_6836_(i, this.network.insertItem(slot, slot.m_41613_(), Action.PERFORM));
                    this.network.getItemStorageTracker().changed(player, slot.m_41777_());
                }
            } else {
                for (int i = 0; i < this.matrix.m_6643_(); ++i) {
                    ItemStack slot = this.matrix.m_8020_(i);
                    if (!slot.m_41619_()) {
                        player.m_150109_().m_36054_(this.matrix.m_8020_(i));
                    }
                    this.onCraftingMatrixChanged();
                }
            }
        } else if (this.type == GridType.PATTERN) {
            this.clearMatrix();
        }
    }

    @Override
    public void onCraftedShift(Player player) {
        API.instance().getCraftingGridBehavior().onCraftedShift(this, player);
    }

    public void onCreatePattern() {
        if (this.canCreatePattern()) {
            if (this.patterns.getStackInSlot(1).m_41619_()) {
                this.patterns.extractItem(0, 1, false);
            }
            ItemStack pattern = new ItemStack((ItemLike)RSItems.PATTERN.get());
            PatternItem.setToCurrentVersion(pattern);
            PatternItem.setProcessing(pattern, this.processingPattern);
            if (!this.processingPattern) {
                PatternItem.setExact(pattern, this.exactPattern);
            } else {
                PatternItem.setAllowedTags(pattern, this.allowedTagList);
            }
            if (this.processingPattern) {
                for (int i = 0; i < this.processingMatrix.getSlots(); ++i) {
                    FluidStack fluid;
                    if (!this.processingMatrix.getStackInSlot(i).m_41619_()) {
                        if (i >= 81) {
                            PatternItem.setOutputSlot(pattern, i - 81, this.processingMatrix.getStackInSlot(i));
                        } else {
                            PatternItem.setInputSlot(pattern, i, this.processingMatrix.getStackInSlot(i));
                        }
                    }
                    if ((fluid = this.processingMatrixFluids.getFluid(i)).isEmpty()) continue;
                    if (i >= 81) {
                        PatternItem.setFluidOutputSlot(pattern, i - 81, fluid);
                        continue;
                    }
                    PatternItem.setFluidInputSlot(pattern, i, fluid);
                }
            } else {
                for (int i = 0; i < 9; ++i) {
                    ItemStack ingredient = this.matrix.m_8020_(i);
                    if (ingredient.m_41619_()) continue;
                    PatternItem.setInputSlot(pattern, i, ingredient);
                }
            }
            this.patterns.setStackInSlot(1, pattern);
        }
    }

    private boolean isPatternAvailable() {
        return !this.patterns.getStackInSlot(0).m_41619_() || !this.patterns.getStackInSlot(1).m_41619_();
    }

    public boolean canCreatePattern() {
        if (!this.isPatternAvailable()) {
            return false;
        }
        if (this.isProcessingPattern()) {
            int i;
            int inputsFilled = 0;
            int outputsFilled = 0;
            for (i = 0; i < 81; ++i) {
                if (!this.processingMatrix.getStackInSlot(i).m_41619_()) {
                    ++inputsFilled;
                }
                if (this.processingMatrixFluids.getFluid(i).isEmpty()) continue;
                ++inputsFilled;
            }
            for (i = 81; i < this.processingMatrix.getSlots(); ++i) {
                if (!this.processingMatrix.getStackInSlot(i).m_41619_()) {
                    ++outputsFilled;
                }
                if (this.processingMatrixFluids.getFluid(i).isEmpty()) continue;
                ++outputsFilled;
            }
            return inputsFilled > 0 && outputsFilled > 0;
        }
        return !this.result.m_8020_(0).m_41619_() && this.isPatternAvailable();
    }

    @Override
    public int getViewType() {
        return this.level.f_46443_ ? GridBlockEntity.VIEW_TYPE.getValue() : this.viewType;
    }

    public void setViewType(int viewType) {
        this.viewType = viewType;
    }

    @Override
    public int getSortingDirection() {
        return this.level.f_46443_ ? GridBlockEntity.SORTING_DIRECTION.getValue() : this.sortingDirection;
    }

    public void setSortingDirection(int sortingDirection) {
        this.sortingDirection = sortingDirection;
    }

    @Override
    public int getSortingType() {
        return this.level.f_46443_ ? GridBlockEntity.SORTING_TYPE.getValue() : this.sortingType;
    }

    public void setSortingType(int sortingType) {
        this.sortingType = sortingType;
    }

    @Override
    public int getSearchBoxMode() {
        return this.level.f_46443_ ? GridBlockEntity.SEARCH_BOX_MODE.getValue() : this.searchBoxMode;
    }

    public void setSearchBoxMode(int searchBoxMode) {
        this.searchBoxMode = searchBoxMode;
    }

    @Override
    public int getSize() {
        return this.level.f_46443_ ? GridBlockEntity.SIZE.getValue() : this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int getTabSelected() {
        return this.level.f_46443_ ? GridBlockEntity.TAB_SELECTED.getValue() : this.tabSelected;
    }

    public void setTabSelected(int tabSelected) {
        this.tabSelected = tabSelected;
    }

    @Override
    public int getTabPage() {
        return this.level.f_46443_ ? GridBlockEntity.TAB_PAGE.getValue() : Math.min(this.tabPage, this.getTotalTabPages());
    }

    public void setTabPage(int page) {
        this.tabPage = page;
    }

    @Override
    public int getTotalTabPages() {
        return (int)Math.floor((float)Math.max(0, this.tabs.size() - 1) / 5.0f);
    }

    @Override
    public void onViewTypeChanged(int type) {
        BlockEntitySynchronizationManager.setParameter(GridBlockEntity.VIEW_TYPE, type);
    }

    @Override
    public void onSortingTypeChanged(int type) {
        BlockEntitySynchronizationManager.setParameter(GridBlockEntity.SORTING_TYPE, type);
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        BlockEntitySynchronizationManager.setParameter(GridBlockEntity.SORTING_DIRECTION, direction);
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        BlockEntitySynchronizationManager.setParameter(GridBlockEntity.SEARCH_BOX_MODE, searchBoxMode);
    }

    @Override
    public void onSizeChanged(int size) {
        BlockEntitySynchronizationManager.setParameter(GridBlockEntity.SIZE, size);
    }

    @Override
    public void onTabSelectionChanged(int tab) {
        BlockEntitySynchronizationManager.setParameter(GridBlockEntity.TAB_SELECTED, tab);
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0 && page <= this.getTotalTabPages()) {
            BlockEntitySynchronizationManager.setParameter(GridBlockEntity.TAB_PAGE, page);
        }
    }

    @Override
    public int getType() {
        return this.level.f_46443_ ? GridBlockEntity.PROCESSING_TYPE.getValue() : this.processingType;
    }

    @Override
    public void setType(int type) {
        this.processingType = type;
        this.markDirty();
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.getProcessingMatrix();
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.getProcessingMatrixFluids();
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        if (tag.m_128441_(NBT_ALLOWED_TAGS)) {
            this.allowedTagList.readFromNbt(tag.m_128469_(NBT_ALLOWED_TAGS));
        }
        this.readingInventory = true;
        StackUtils.readItems((Container)this.matrix, 0, tag);
        StackUtils.readItems(this.patterns, 1, tag);
        StackUtils.readItems(this.filter, 2, tag);
        StackUtils.readItems(this.processingMatrix, 3, tag);
        if (tag.m_128441_(NBT_PROCESSING_MATRIX_FLUIDS)) {
            this.processingMatrixFluids.readFromNbt(tag.m_128469_(NBT_PROCESSING_MATRIX_FLUIDS));
        }
        if (tag.m_128441_(NBT_TAB_SELECTED)) {
            this.tabSelected = tag.m_128451_(NBT_TAB_SELECTED);
        }
        if (tag.m_128441_(NBT_TAB_PAGE)) {
            this.tabPage = tag.m_128451_(NBT_TAB_PAGE);
        }
        this.readingInventory = false;
    }

    @Override
    public ResourceLocation getId() {
        return GridNetworkNode.getId(this.type);
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        tag.m_128365_(NBT_ALLOWED_TAGS, (Tag)this.allowedTagList.writeToNbt());
        StackUtils.writeItems((Container)this.matrix, 0, tag);
        StackUtils.writeItems((IItemHandler)this.patterns, 1, tag);
        StackUtils.writeItems((IItemHandler)this.filter, 2, tag);
        StackUtils.writeItems((IItemHandler)this.processingMatrix, 3, tag);
        tag.m_128365_(NBT_PROCESSING_MATRIX_FLUIDS, (Tag)this.processingMatrixFluids.writeToNbt());
        tag.m_128405_(NBT_TAB_SELECTED, this.tabSelected);
        tag.m_128405_(NBT_TAB_PAGE, this.tabPage);
        return tag;
    }

    @Override
    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128405_(NBT_VIEW_TYPE, this.viewType);
        tag.m_128405_(NBT_SORTING_DIRECTION, this.sortingDirection);
        tag.m_128405_(NBT_SORTING_TYPE, this.sortingType);
        tag.m_128405_(NBT_SEARCH_BOX_MODE, this.searchBoxMode);
        tag.m_128405_(NBT_SIZE, this.size);
        tag.m_128379_(NBT_EXACT_MODE, this.exactPattern);
        tag.m_128379_(NBT_PROCESSING_PATTERN, this.processingPattern);
        tag.m_128405_(NBT_PROCESSING_TYPE, this.processingType);
        return tag;
    }

    @Override
    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_VIEW_TYPE)) {
            this.viewType = tag.m_128451_(NBT_VIEW_TYPE);
        }
        if (tag.m_128441_(NBT_SORTING_DIRECTION)) {
            this.sortingDirection = tag.m_128451_(NBT_SORTING_DIRECTION);
        }
        if (tag.m_128441_(NBT_SORTING_TYPE)) {
            this.sortingType = tag.m_128451_(NBT_SORTING_TYPE);
        }
        if (tag.m_128441_(NBT_SEARCH_BOX_MODE)) {
            this.searchBoxMode = tag.m_128451_(NBT_SEARCH_BOX_MODE);
        }
        if (tag.m_128441_(NBT_SIZE)) {
            this.size = tag.m_128451_(NBT_SIZE);
        }
        if (tag.m_128441_(NBT_EXACT_MODE)) {
            this.exactPattern = tag.m_128471_(NBT_EXACT_MODE);
        }
        if (tag.m_128441_(NBT_PROCESSING_PATTERN)) {
            this.processingPattern = tag.m_128471_(NBT_PROCESSING_PATTERN);
        }
        if (tag.m_128441_(NBT_PROCESSING_TYPE)) {
            this.processingType = tag.m_128451_(NBT_PROCESSING_TYPE);
        }
    }

    @Override
    public IItemHandler getDrops() {
        switch (this.type) {
            case CRAFTING: {
                return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.filter, new InvWrapper((Container)this.matrix)});
            }
            case PATTERN: {
                return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.filter, this.patterns});
            }
        }
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.filter});
    }
}

