/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.blockentity.DiskDriveBlockEntity;
import com.refinedmods.refinedstorage.blockentity.ImporterBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ImporterNetworkNode
extends NetworkNode
implements IComparable,
IWhitelistBlacklist,
IType,
ICoverable {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "importer");
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FLuidFilters";
    private final BaseItemHandler itemFilters = new BaseItemHandler(9).addListener(new NetworkNodeInventoryListener(this));
    private final FluidInventory fluidFilters = new FluidInventory(9).addListener(new NetworkNodeFluidInventoryListener(this));
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, UpgradeItem.Type.SPEED, UpgradeItem.Type.STACK).addListener(new NetworkNodeInventoryListener(this));
    private final CoverManager coverManager = new CoverManager(this);
    private int compare = 1;
    private int mode = 1;
    private int type = 0;
    private int currentSlot;

    public ImporterNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getImporter().getUsage() + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        FluidStack extracted;
        FluidStack extractedSimulated;
        IFluidHandler handler;
        super.update();
        if (!this.canUpdate() || !this.level.m_46749_(this.pos)) {
            return;
        }
        if (this.type == 0) {
            BlockEntity facing = this.getFacingBlockEntity();
            IItemHandler handler2 = LevelUtils.getItemHandler(facing, this.getDirection().m_122424_());
            if (facing instanceof DiskDriveBlockEntity || handler2 == null) {
                return;
            }
            if (this.currentSlot >= handler2.getSlots()) {
                this.currentSlot = 0;
            }
            if (handler2.getSlots() > 0) {
                while (this.currentSlot + 1 < handler2.getSlots() && handler2.getStackInSlot(this.currentSlot).m_41619_()) {
                    ++this.currentSlot;
                }
                ItemStack stack = handler2.getStackInSlot(this.currentSlot);
                if (!IWhitelistBlacklist.acceptsItem((IItemHandler)this.itemFilters, this.mode, this.compare, stack)) {
                    ++this.currentSlot;
                } else if (this.ticks % this.upgrades.getSpeed() == 0) {
                    ItemStack result = handler2.extractItem(this.currentSlot, this.upgrades.getStackInteractCount(), true);
                    if (!result.m_41619_() && this.network.insertItem(result, result.m_41613_(), Action.SIMULATE).m_41619_()) {
                        result = handler2.extractItem(this.currentSlot, this.upgrades.getStackInteractCount(), false);
                        this.network.insertItemTracked(result, result.m_41613_());
                    } else {
                        ++this.currentSlot;
                    }
                }
            }
        } else if (this.type == 1 && this.ticks % this.upgrades.getSpeed() == 0 && (handler = LevelUtils.getFluidHandler(this.getFacingBlockEntity(), this.getDirection().m_122424_())) != null && !(extractedSimulated = handler.drain(1000 * this.upgrades.getStackInteractCount(), IFluidHandler.FluidAction.SIMULATE)).isEmpty() && IWhitelistBlacklist.acceptsFluid(this.fluidFilters, this.mode, this.compare, extractedSimulated) && this.network.insertFluid(extractedSimulated, extractedSimulated.getAmount(), Action.SIMULATE).isEmpty() && !(extracted = handler.drain(extractedSimulated, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
            this.network.insertFluidTracked(extracted, extracted.getAmount());
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    @Override
    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        if (tag.m_128441_(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.m_128469_(CoverManager.NBT_COVER_MANAGER));
        }
        StackUtils.readItems(this.upgrades, 1, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        tag.m_128365_(CoverManager.NBT_COVER_MANAGER, (Tag)this.coverManager.writeToNbt());
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128405_(NBT_COMPARE, this.compare);
        tag.m_128405_(NBT_MODE, this.mode);
        tag.m_128405_(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilters.writeToNbt());
        return tag;
    }

    @Override
    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
        if (tag.m_128441_(NBT_MODE)) {
            this.mode = tag.m_128451_(NBT_MODE);
        }
        if (tag.m_128441_(NBT_TYPE)) {
            this.type = tag.m_128451_(NBT_TYPE);
        }
        StackUtils.readItems(this.itemFilters, 0, tag);
        if (tag.m_128441_(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.m_128469_(NBT_FLUID_FILTERS));
        }
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.getUpgrades();
    }

    @Override
    public int getType() {
        return this.level.f_46443_ ? ImporterBlockEntity.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    @Override
    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

