/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.tracker;

import com.refinedmods.refinedstorage.api.storage.tracker.IStorageTracker;
import com.refinedmods.refinedstorage.api.storage.tracker.StorageTrackerEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fluids.FluidStack;

public class FluidStorageTracker
implements IStorageTracker<FluidStack> {
    private static final String NBT_STACK = "Stack";
    private static final String NBT_NAME = "Name";
    private static final String NBT_TIME = "Time";
    private final Map<Key, StorageTrackerEntry> changes = new HashMap<Key, StorageTrackerEntry>();
    private final Runnable listener;

    public FluidStorageTracker(Runnable listener) {
        this.listener = listener;
    }

    @Override
    public void changed(Player player, FluidStack stack) {
        this.changes.put(new Key(stack), new StorageTrackerEntry(System.currentTimeMillis(), player.m_7755_().getString()));
        this.listener.run();
    }

    @Override
    public StorageTrackerEntry get(FluidStack stack) {
        return this.changes.get(new Key(stack));
    }

    @Override
    public void readFromNbt(ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_(NBT_STACK));
            if (stack.isEmpty()) continue;
            this.changes.put(new Key(stack), new StorageTrackerEntry(tag.m_128454_(NBT_TIME), tag.m_128461_(NBT_NAME)));
        }
    }

    @Override
    public ListTag serializeNbt() {
        ListTag list = new ListTag();
        for (Map.Entry<Key, StorageTrackerEntry> entry : this.changes.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_(NBT_TIME, entry.getValue().getTime());
            tag.m_128359_(NBT_NAME, entry.getValue().getName());
            tag.m_128365_(NBT_STACK, (Tag)entry.getKey().stack.writeToNBT(new CompoundTag()));
            list.add((Object)tag);
        }
        return list;
    }

    private static class Key {
        private final FluidStack stack;

        public Key(FluidStack stack) {
            this.stack = stack;
        }

        public boolean equals(Object other) {
            return other instanceof Key && API.instance().getComparer().isEqual(this.stack, ((Key)other).stack, 1);
        }

        public int hashCode() {
            return API.instance().getFluidStackHashCode(this.stack);
        }
    }
}

