/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity;

import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.apiimpl.network.node.FluidInterfaceNetworkNode;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationSpec;
import com.refinedmods.refinedstorage.blockentity.data.RSSerializers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class FluidInterfaceBlockEntity
extends NetworkNodeBlockEntity<FluidInterfaceNetworkNode> {
    public static final BlockEntitySynchronizationParameter<FluidStack, FluidInterfaceBlockEntity> TANK_IN = new BlockEntitySynchronizationParameter<FluidStack, FluidInterfaceBlockEntity>(RSSerializers.FLUID_STACK_SERIALIZER, FluidStack.EMPTY, t -> ((FluidInterfaceNetworkNode)t.getNode()).getTankIn().getFluid());
    public static final BlockEntitySynchronizationParameter<FluidStack, FluidInterfaceBlockEntity> TANK_OUT = new BlockEntitySynchronizationParameter<FluidStack, FluidInterfaceBlockEntity>(RSSerializers.FLUID_STACK_SERIALIZER, FluidStack.EMPTY, t -> ((FluidInterfaceNetworkNode)t.getNode()).getTankOut().getFluid());
    public static BlockEntitySynchronizationSpec SPEC = BlockEntitySynchronizationSpec.builder().addWatchedParameter(REDSTONE_MODE).addParameter(TANK_IN).addParameter(TANK_OUT).build();
    private final LazyOptional<IFluidHandler> tankCapability = LazyOptional.of(() -> ((FluidInterfaceNetworkNode)this.getNode()).getTank());
    private final LazyOptional<IItemHandler> inCapability = LazyOptional.of(() -> ((FluidInterfaceNetworkNode)this.getNode()).getIn());

    public FluidInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RSBlockEntities.FLUID_INTERFACE.get(), pos, state, SPEC, FluidInterfaceNetworkNode.class);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.tankCapability.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Override
    @Nonnull
    public FluidInterfaceNetworkNode createNode(Level level, BlockPos pos) {
        return new FluidInterfaceNetworkNode(level, pos);
    }
}

