/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.command.network;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.render.Styles;
import java.text.DecimalFormat;
import java.util.Comparator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;

public class ListNetworkCommand
implements Command<CommandSourceStack> {
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("########0.000");

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"list").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes((Command)new ListNetworkCommand()));
    }

    public static void sendInfo(CommandContext<CommandSourceStack> context, NetworkInList listItem, boolean detailed) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"commands.refinedstorage.network.list.pos", (Object[])new Object[]{listItem.network.getPosition().m_123341_(), listItem.network.getPosition().m_123342_(), listItem.network.getPosition().m_123343_()}).m_130946_(" [").m_7220_((Component)Component.m_237110_((String)"commands.refinedstorage.network.list.tick_times", (Object[])new Object[]{Component.m_237113_((String)TIME_FORMATTER.format(listItem.tickTime)).m_6270_(Styles.YELLOW), Component.m_237113_((String)TIME_FORMATTER.format(listItem.tps)).m_6270_(Styles.YELLOW)})).m_130946_("]"), false);
        if (detailed) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"commands.refinedstorage.network.list.autocrafting_tasks", (Object[])new Object[]{Component.m_237113_((String)("" + listItem.network.getCraftingManager().getTasks().size())).m_6270_(Styles.YELLOW)}), false);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"commands.refinedstorage.network.list.nodes", (Object[])new Object[]{Component.m_237113_((String)("" + listItem.network.getNodeGraph().all().size())).m_6270_(Styles.YELLOW)}), false);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"commands.refinedstorage.network.list.energy_usage", (Object[])new Object[]{Component.m_237113_((String)("" + listItem.network.getEnergyUsage())).m_6270_(Styles.YELLOW)}), false);
        }
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel level = DimensionArgument.m_88808_(context, (String)"dimension");
        API.instance().getNetworkManager(level).all().stream().map(NetworkInList::new).sorted(Comparator.comparingDouble(network -> network.tickTime)).forEach(listItem -> ListNetworkCommand.sendInfo(context, listItem, false));
        return 0;
    }

    public static class NetworkInList {
        private final double tickTime;
        private final double tps;
        private final INetwork network;

        public NetworkInList(INetwork network) {
            this.network = network;
            this.tickTime = (double)this.mean(network.getTickTimes()) * 1.0E-6;
            this.tps = Math.min(1000.0 / this.tickTime, 20.0);
        }

        private long mean(long[] values) {
            long sum = 0L;
            for (long v : values) {
                sum += v;
            }
            return sum / (long)values.length;
        }
    }
}

