/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.container;

import com.refinedmods.refinedstorage.RSContainerMenus;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.refinedmods.refinedstorage.blockentity.BaseBlockEntity;
import com.refinedmods.refinedstorage.blockentity.grid.portable.IPortableGrid;
import com.refinedmods.refinedstorage.container.BaseContainerMenu;
import com.refinedmods.refinedstorage.container.slot.filter.FilterSlot;
import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import com.refinedmods.refinedstorage.container.slot.grid.CraftingGridSlot;
import com.refinedmods.refinedstorage.container.slot.grid.ResultCraftingGridSlot;
import com.refinedmods.refinedstorage.container.slot.legacy.LegacyBaseSlot;
import com.refinedmods.refinedstorage.container.slot.legacy.LegacyDisabledSlot;
import com.refinedmods.refinedstorage.container.slot.legacy.LegacyFilterSlot;
import com.refinedmods.refinedstorage.screen.IScreenInfoProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class GridContainerMenu
extends BaseContainerMenu
implements ICraftingGridListener {
    private final IGrid grid;
    private IStorageCache storageCache;
    private IStorageCacheListener storageCacheListener;
    private IScreenInfoProvider screenInfoProvider;
    private ResultCraftingGridSlot craftingResultSlot;
    private LegacyBaseSlot patternResultSlot;
    private List<Slot> itemPatternSlots = new ArrayList<Slot>();
    private List<Slot> fluidPatternSlots = new ArrayList<Slot>();
    private int patternScrollOffset;

    public GridContainerMenu(IGrid grid, @Nullable BaseBlockEntity blockEntity, Player player, int windowId) {
        super((MenuType)RSContainerMenus.GRID.get(), blockEntity, player, windowId);
        this.grid = grid;
        grid.addCraftingListener(this);
    }

    public IScreenInfoProvider getScreenInfoProvider() {
        return this.screenInfoProvider;
    }

    public void setScreenInfoProvider(IScreenInfoProvider screenInfoProvider) {
        this.screenInfoProvider = screenInfoProvider;
    }

    public void initSlots() {
        this.f_38839_.clear();
        this.f_38841_.clear();
        this.transferManager.clearTransfers();
        this.addFilterSlots();
        if (this.grid instanceof IPortableGrid) {
            this.addPortableGridSlots();
        }
        if (this.grid.getGridType() == GridType.CRAFTING) {
            this.addCraftingSlots();
        } else if (this.grid.getGridType() == GridType.PATTERN) {
            this.addPatternSlots();
        }
        this.transferManager.setNotFoundHandler(slotIndex -> {
            if (!this.getPlayer().m_20193_().f_46443_) {
                Slot slot = (Slot)this.f_38839_.get(slotIndex.intValue());
                if (this.grid instanceof IPortableGrid && slot instanceof SlotItemHandler && ((SlotItemHandler)slot).getItemHandler().equals((Object)((IPortableGrid)((Object)this.grid)).getDiskInventory())) {
                    return ItemStack.f_41583_;
                }
                if (slot.m_6657_()) {
                    if (slot == this.craftingResultSlot) {
                        this.grid.onCraftedShift(this.getPlayer());
                        this.m_38946_();
                    } else {
                        ItemStack stack = slot.m_7993_();
                        if (this.grid.getGridType() == GridType.FLUID) {
                            IFluidGridHandler fluidHandler = this.grid.getFluidHandler();
                            if (fluidHandler != null) {
                                slot.m_5852_(fluidHandler.onInsert((ServerPlayer)this.getPlayer(), stack));
                            }
                        } else {
                            IItemGridHandler itemHandler = this.grid.getItemHandler();
                            if (itemHandler != null) {
                                slot.m_5852_(itemHandler.onInsert((ServerPlayer)this.getPlayer(), stack, false));
                            } else if (slot instanceof CraftingGridSlot && this.m_38903_(stack, 14, 50, false)) {
                                slot.m_6654_();
                                this.grid.onCraftingMatrixChanged();
                            }
                        }
                        this.m_38946_();
                    }
                }
            }
            return ItemStack.f_41583_;
        });
        this.addPlayerInventory(8, this.screenInfoProvider.getYPlayerInventory());
    }

    private void addPortableGridSlots() {
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)((IPortableGrid)((Object)this.grid)).getDiskInventory(), 0, 204, 6));
        this.transferManager.addBiTransfer((Container)this.getPlayer().m_150109_(), (IItemHandler)((IPortableGrid)((Object)this.grid)).getDiskInventory());
    }

    private void addFilterSlots() {
        int yStart = 6;
        if (this.grid instanceof IPortableGrid) {
            yStart = 38;
        }
        for (int i = 0; i < 4; ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.grid.getFilter(), i, 204, yStart + 18 * i));
        }
        this.transferManager.addBiTransfer((Container)this.getPlayer().m_150109_(), (IItemHandler)this.grid.getFilter());
    }

    private void addCraftingSlots() {
        int headerAndSlots = this.screenInfoProvider.getTopHeight() + this.screenInfoProvider.getVisibleRows() * 18;
        int x = 26;
        int y = headerAndSlots + 4;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new CraftingGridSlot((Container)this.grid.getCraftingMatrix(), i, x, y));
            x += 18;
            if ((i + 1) % 3 != 0) continue;
            y += 18;
            x = 26;
        }
        this.craftingResultSlot = new ResultCraftingGridSlot(this.getPlayer(), this.grid, 0, 134, headerAndSlots + 22);
        this.m_38897_((Slot)this.craftingResultSlot);
    }

    private void addPatternSlots() {
        int i;
        int ox;
        this.itemPatternSlots.clear();
        this.fluidPatternSlots.clear();
        int headerAndSlots = this.screenInfoProvider.getTopHeight() + this.screenInfoProvider.getVisibleRows() * 18;
        this.m_38897_((Slot)new SlotItemHandler(((GridNetworkNode)this.grid).getPatterns(), 0, 172, headerAndSlots + 4));
        this.m_38897_((Slot)new SlotItemHandler(((GridNetworkNode)this.grid).getPatterns(), 1, 172, headerAndSlots + 40));
        this.transferManager.addBiTransfer((Container)this.getPlayer().m_150109_(), ((GridNetworkNode)this.grid).getPatterns());
        int x = ox = 8;
        int y = headerAndSlots + 4;
        for (i = 0; i < 162; ++i) {
            int itemFilterSlotConfig = 1;
            if (i < 81) {
                itemFilterSlotConfig |= 4;
            }
            int fluidFilterSlotConfig = 1;
            if (i < 81) {
                fluidFilterSlotConfig |= 2;
            }
            int finalI = i;
            this.itemPatternSlots.add(this.m_38897_((Slot)new FilterSlot((IItemHandler)((GridNetworkNode)this.grid).getProcessingMatrix(), i, x, y, itemFilterSlotConfig).setEnableHandler(() -> this.getSlotEnabled(finalI, true))));
            this.fluidPatternSlots.add(this.m_38897_((Slot)new FluidFilterSlot(((GridNetworkNode)this.grid).getProcessingMatrixFluids(), i, x, y, fluidFilterSlotConfig).setEnableHandler(() -> this.getSlotEnabled(finalI, false))));
            x += 18;
            if ((i + 1) % 3 != 0) continue;
            if (i == 80) {
                x = ox = 93;
                y = headerAndSlots + 4;
                continue;
            }
            x = ox;
            y += 18;
        }
        x = 26;
        y = headerAndSlots + 4;
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new LegacyFilterSlot((Container)this.grid.getCraftingMatrix(), i, x, y).setEnableHandler(() -> !((GridNetworkNode)this.grid).isProcessingPattern()));
            x += 18;
            if ((i + 1) % 3 != 0) continue;
            y += 18;
            x = 26;
        }
        this.patternResultSlot = new LegacyDisabledSlot((Container)this.grid.getCraftingResult(), 0, 134, headerAndSlots + 22).setEnableHandler(() -> !((GridNetworkNode)this.grid).isProcessingPattern());
        this.m_38897_(this.patternResultSlot);
    }

    private boolean getSlotEnabled(int i, boolean item) {
        if (!((GridNetworkNode)this.grid).isProcessingPattern() || !this.isVisible(i)) {
            return false;
        }
        if (item) {
            if (this.itemPatternSlots.get(i).m_6657_()) {
                return true;
            }
            if (((FluidFilterSlot)this.fluidPatternSlots.get(i)).hasStack()) {
                return false;
            }
            return ((GridNetworkNode)this.grid).getType() == 0;
        }
        if (((FluidFilterSlot)this.fluidPatternSlots.get(i)).hasStack()) {
            return true;
        }
        if (this.itemPatternSlots.get(i).m_6657_()) {
            return false;
        }
        return ((GridNetworkNode)this.grid).getType() == 1;
    }

    private boolean isVisible(int slotNumber) {
        return slotNumber >= this.patternScrollOffset * 3 && slotNumber < this.patternScrollOffset * 3 + 9 || slotNumber >= this.patternScrollOffset * 3 + 81 && slotNumber < this.patternScrollOffset * 3 + 81 + 9;
    }

    public IGrid getGrid() {
        return this.grid;
    }

    @Override
    public void onCraftingMatrixChanged() {
        for (int i = 0; i < this.f_38839_.size(); ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (!(slot instanceof CraftingGridSlot) && slot != this.craftingResultSlot && slot != this.patternResultSlot) continue;
            for (ContainerListener listener : this.f_38848_) {
                if (!(listener instanceof ServerPlayer)) continue;
                ((ServerPlayer)listener).f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), i, slot.m_7993_()));
            }
        }
    }

    @Override
    public void m_38946_() {
        if (!this.getPlayer().f_19853_.f_46443_) {
            if (this.grid.getStorageCache() == null) {
                if (this.storageCacheListener != null) {
                    this.storageCache.removeListener(this.storageCacheListener);
                    this.storageCacheListener = null;
                    this.storageCache = null;
                }
            } else if (this.storageCacheListener == null) {
                this.storageCacheListener = this.grid.createListener((ServerPlayer)this.getPlayer());
                this.storageCache = this.grid.getStorageCache();
                this.storageCache.addListener(this.storageCacheListener);
            }
        }
        super.m_38946_();
    }

    @Override
    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_20193_().f_46443_) {
            this.grid.onClosed(player);
            if (this.storageCache != null && this.storageCacheListener != null) {
                this.storageCache.removeListener(this.storageCacheListener);
            }
        }
        this.grid.removeCraftingListener(this);
    }

    @Override
    public boolean m_5882_(ItemStack stack, Slot slot) {
        if (slot == this.craftingResultSlot || slot == this.patternResultSlot) {
            return false;
        }
        return super.m_5882_(stack, slot);
    }

    @Override
    public int getDisabledSlotNumber() {
        return this.grid.getSlotId();
    }

    public void updatePatternSlotPositions(int newOffset) {
        int yPosition;
        this.patternScrollOffset = newOffset;
        int originalYPosition = yPosition = this.screenInfoProvider.getTopHeight() + this.screenInfoProvider.getVisibleRows() * 18 + 4;
        for (int i = 0; i < this.itemPatternSlots.size(); ++i) {
            if (i == 81) {
                yPosition = originalYPosition;
            }
            if (!this.isVisible(i)) continue;
            this.itemPatternSlots.get((int)i).f_40221_ = yPosition;
            this.fluidPatternSlots.get((int)i).f_40221_ = yPosition;
            if ((i + 1) % 3 != 0) continue;
            yPosition += 18;
        }
    }
}

