/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.item.capabilityprovider.EnergyCapabilityProvider;
import com.refinedmods.refinedstorage.render.Styles;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class EnergyItem
extends Item {
    private final Supplier<Integer> energyCapacity;
    private final boolean creative;

    protected EnergyItem(Item.Properties properties, boolean creative, Supplier<Integer> energyCapacity) {
        super(properties);
        this.creative = creative;
        this.energyCapacity = energyCapacity;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new EnergyCapabilityProvider(stack, this.energyCapacity.get());
    }

    public boolean m_142522_(ItemStack stack) {
        return !this.creative;
    }

    public int m_142158_(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
        if (energy == null) {
            return 0;
        }
        float stored = (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored();
        return Math.round(stored * 13.0f);
    }

    public int m_142159_(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        if (energy == null) {
            return super.m_142159_(stack);
        }
        return Mth.m_14169_((float)(Math.max(0.0f, (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (!this.creative) {
            stack.getCapability(ForgeCapabilities.ENERGY, null).ifPresent(energy -> tooltip.add((Component)Component.m_237110_((String)"misc.refinedstorage.energy_stored", (Object[])new Object[]{energy.getEnergyStored(), energy.getMaxEnergyStored()}).m_6270_(Styles.GRAY)));
        }
    }
}

