/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.refinedmods.refinedstorage.render.model.AbstractUnbakedGeometry;
import com.refinedmods.refinedstorage.render.model.baked.DiskDriveBakedModel;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;

public class DiskDriveUnbakedGeometry
extends AbstractUnbakedGeometry<DiskDriveUnbakedGeometry> {
    private static final ResourceLocation BASE_MODEL = new ResourceLocation("refinedstorage", "block/disk_drive_base");
    private static final ResourceLocation DISK_MODEL = new ResourceLocation("refinedstorage", "block/disks/disk");
    private static final ResourceLocation DISK_DISCONNECTED_MODEL = new ResourceLocation("refinedstorage", "block/disks/disk_disconnected");
    private static final ResourceLocation DISK_FULL_MODEL = new ResourceLocation("refinedstorage", "block/disks/disk_full");
    private static final ResourceLocation DISK_NEAR_CAPACITY_MODEL = new ResourceLocation("refinedstorage", "block/disks/disk_near_capacity");

    @Override
    protected Set<ResourceLocation> getModels() {
        return Set.of(BASE_MODEL, DISK_MODEL, DISK_DISCONNECTED_MODEL, DISK_FULL_MODEL, DISK_NEAR_CAPACITY_MODEL);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new DiskDriveBakedModel(Objects.requireNonNull(bakery.bake(BASE_MODEL, modelState, spriteGetter)), this.getBaseModelBakery(modelState, bakery, spriteGetter), this.getDiskModelBakery(DISK_MODEL, modelState, bakery, spriteGetter), this.getDiskModelBakery(DISK_NEAR_CAPACITY_MODEL, modelState, bakery, spriteGetter), this.getDiskModelBakery(DISK_FULL_MODEL, modelState, bakery, spriteGetter), this.getDiskModelBakery(DISK_DISCONNECTED_MODEL, modelState, bakery, spriteGetter));
    }

    private Function<Direction, BakedModel> getBaseModelBakery(ModelState state, ModelBakery bakery, Function<Material, TextureAtlasSprite> sg) {
        return direction -> {
            Transformation rotation = new Transformation(null, RenderUtils.getQuaternion(direction), null, null);
            SimpleModelState wrappedState = new SimpleModelState(rotation, state.m_7538_());
            return bakery.bake(BASE_MODEL, (ModelState)wrappedState, sg);
        };
    }

    private BiFunction<Direction, Vector3f, BakedModel> getDiskModelBakery(ResourceLocation id, ModelState state, ModelBakery bakery, Function<Material, TextureAtlasSprite> sg) {
        return (direction, trans) -> {
            Transformation translation = new Transformation(trans, null, null, null);
            Transformation rotation = new Transformation(null, RenderUtils.getQuaternion(direction), null, null);
            SimpleModelState wrappedState = new SimpleModelState(rotation.m_121096_(translation), state.m_7538_());
            return bakery.bake(id, (ModelState)wrappedState, sg);
        };
    }
}

