/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.refinedmods.refinedstorage.render.model.AbstractUnbakedGeometry;
import com.refinedmods.refinedstorage.render.model.baked.DiskManipulatorBakedModel;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;

public class DiskManipulatorUnbakedGeometry
extends AbstractUnbakedGeometry<DiskManipulatorUnbakedGeometry> {
    private static final ResourceLocation BASE_MODEL_DISCONNECTED = new ResourceLocation("refinedstorage", "block/disk_manipulator/disconnected");
    private final Map<DyeColor, ResourceLocation> BASE_MODEL_CONNECTED = new HashMap<DyeColor, ResourceLocation>();
    private static final ResourceLocation DISK_MODEL = new ResourceLocation("refinedstorage", "block/disks/disk");
    private static final ResourceLocation DISK_DISCONNECTED_MODEL = new ResourceLocation("refinedstorage", "block/disks/disk_disconnected");
    private static final ResourceLocation DISK_FULL_MODEL = new ResourceLocation("refinedstorage", "block/disks/disk_full");
    private static final ResourceLocation DISK_NEAR_CAPACITY_MODEL = new ResourceLocation("refinedstorage", "block/disks/disk_near_capacity");

    @Override
    protected Set<ResourceLocation> getModels() {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>(Set.of(BASE_MODEL_DISCONNECTED, DISK_MODEL, DISK_DISCONNECTED_MODEL, DISK_FULL_MODEL, DISK_NEAR_CAPACITY_MODEL));
        set.addAll(this.BASE_MODEL_CONNECTED.values());
        return set;
    }

    public DiskManipulatorUnbakedGeometry() {
        for (DyeColor value : DyeColor.values()) {
            this.BASE_MODEL_CONNECTED.put(value, new ResourceLocation("refinedstorage", "block/disk_manipulator/" + value.m_41065_()));
        }
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        ResourceLocation renderTypeHint = context.getRenderTypeHint();
        RenderTypeGroup renderTypes = renderTypeHint != null ? context.getRenderType(renderTypeHint) : RenderTypeGroup.EMPTY;
        return new DiskManipulatorBakedModel(Objects.requireNonNull(bakery.bake(BASE_MODEL_DISCONNECTED, modelState, spriteGetter)), this.getBaseModelBakeryConnected(modelState, bakery, spriteGetter), this.getBaseModelBakery(modelState, bakery, spriteGetter), this.getDiskModelBakery(DISK_MODEL, modelState, bakery, spriteGetter), this.getDiskModelBakery(DISK_NEAR_CAPACITY_MODEL, modelState, bakery, spriteGetter), this.getDiskModelBakery(DISK_FULL_MODEL, modelState, bakery, spriteGetter), this.getDiskModelBakery(DISK_DISCONNECTED_MODEL, modelState, bakery, spriteGetter), renderTypes);
    }

    private Function<Direction, BakedModel> getBaseModelBakery(ModelState state, ModelBakery bakery, Function<Material, TextureAtlasSprite> sg) {
        return direction -> {
            Quaternion dir = RenderUtils.getQuaternion(direction);
            Transformation rotation = new Transformation(null, dir, null, null);
            SimpleModelState wrappedState = new SimpleModelState(rotation, state.m_7538_());
            return bakery.bake(BASE_MODEL_DISCONNECTED, (ModelState)wrappedState, sg);
        };
    }

    private BiFunction<Direction, DyeColor, BakedModel> getBaseModelBakeryConnected(ModelState state, ModelBakery bakery, Function<Material, TextureAtlasSprite> sg) {
        return (direction, color) -> {
            Quaternion dir = RenderUtils.getQuaternion(direction);
            Transformation rotation = new Transformation(null, dir, null, null);
            SimpleModelState wrappedState = new SimpleModelState(rotation, state.m_7538_());
            return bakery.bake(this.BASE_MODEL_CONNECTED.get(color), (ModelState)wrappedState, sg);
        };
    }

    private BiFunction<Direction, Vector3f, BakedModel> getDiskModelBakery(ResourceLocation id, ModelState state, ModelBakery bakery, Function<Material, TextureAtlasSprite> sg) {
        return (direction, trans) -> {
            Quaternion dir = RenderUtils.getQuaternion(direction);
            Transformation translation = new Transformation(trans, null, null, null);
            Transformation rotation = new Transformation(null, dir, null, null);
            SimpleModelState wrappedState = new SimpleModelState(rotation.m_121096_(translation), state.m_7538_());
            return bakery.bake(id, (ModelState)wrappedState, sg);
        };
    }
}

