/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.container.slot.filter.FilterSlot;
import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import com.refinedmods.refinedstorage.render.FluidRenderer;
import com.refinedmods.refinedstorage.render.RenderSettings;
import com.refinedmods.refinedstorage.screen.FluidAmountScreen;
import com.refinedmods.refinedstorage.screen.ItemAmountScreen;
import com.refinedmods.refinedstorage.screen.grid.AlternativesScreen;
import com.refinedmods.refinedstorage.screen.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.SideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public abstract class BaseScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public static final int Z_LEVEL_ITEMS = 100;
    public static final int Z_LEVEL_QTY = 300;
    private static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();
    private static final Map<Class, Queue<Consumer>> ACTIONS = new HashMap<Class, Queue<Consumer>>();
    private static final Component ALTERNATIVES_TEXT = Component.m_237115_((String)"gui.refinedstorage.alternatives");
    protected final Inventory inventory;
    private final List<SideButton> sideButtons = new ArrayList<SideButton>();
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private int sideButtonY;

    protected BaseScreen(T containerMenu, int xSize, int ySize, Inventory inventory, Component title) {
        super(containerMenu, inventory, title);
        this.f_97726_ = xSize;
        this.f_97727_ = ySize;
        this.inventory = inventory;
    }

    public static boolean isKeyDown(KeyMapping keybinding) {
        return !keybinding.m_90862_() && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keybinding.getKey().m_84873_()) && keybinding.getKeyConflictContext().isActive() && keybinding.getKeyModifier().isActive(keybinding.getKeyConflictContext());
    }

    public static <T> void executeLater(Class<T> clazz, Consumer<T> callback) {
        ACTIONS.computeIfAbsent(clazz, key -> new ArrayDeque()).add(callback);
    }

    public static void executeLater(Consumer<AbstractContainerScreen> callback) {
        BaseScreen.executeLater(AbstractContainerScreen.class, callback);
    }

    public void runActions() {
        this.runActions(((Object)((Object)this)).getClass());
        this.runActions(AbstractContainerScreen.class);
    }

    private void runActions(Class clazz) {
        Queue<Consumer> queue = ACTIONS.get(clazz);
        if (queue != null && !queue.isEmpty()) {
            Consumer callback;
            while ((callback = queue.poll()) != null) {
                callback.accept(this);
            }
        }
    }

    public void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.onPreInit();
        super.m_7856_();
        this.m_169413_();
        this.sideButtonY = 6;
        this.sideButtons.clear();
        this.onPostInit(this.f_97735_, this.f_97736_);
        this.runActions();
    }

    public void m_7861_() {
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.runActions();
        this.tick(this.f_97735_, this.f_97736_);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack poseStack, float renderPartialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderBackground(poseStack, this.f_97735_, this.f_97736_, mouseX, mouseY);
        for (int i = 0; i < this.f_97732_.f_38839_.size(); ++i) {
            FluidStack stack;
            Slot slot = (Slot)this.f_97732_.f_38839_.get(i);
            if (!slot.m_6659_() || !(slot instanceof FluidFilterSlot) || (stack = ((FluidFilterSlot)slot).getFluidInventory().getFluid(slot.getSlotIndex())).isEmpty()) continue;
            FluidRenderer.INSTANCE.render(poseStack, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, stack);
            if (!((FluidFilterSlot)slot).isSizeAllowed()) continue;
            this.renderQuantity(poseStack, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, API.instance().getQuantityFormatter().formatInBucketForm(stack.getAmount()), RenderSettings.INSTANCE.getSecondaryColor());
            GL11.glDisable((int)2896);
        }
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderForeground(poseStack, mouseX -= this.f_97735_, mouseY -= this.f_97736_);
        for (Widget button : this.f_169369_) {
            if (!(button instanceof SideButton)) continue;
            SideButton sideButton = (SideButton)button;
            sideButton.renderTooltip(poseStack, mouseX, mouseY);
        }
        for (int i = 0; i < this.f_97732_.f_38839_.size(); ++i) {
            FluidStack stack;
            Slot slot = (Slot)this.f_97732_.f_38839_.get(i);
            if (!slot.m_6659_() || !(slot instanceof FluidFilterSlot) || (stack = ((FluidFilterSlot)slot).getFluidInventory().getFluid(slot.getSlotIndex())).isEmpty() || !RenderUtils.inBounds(slot.f_40220_, slot.f_40221_, 17, 17, mouseX, mouseY)) continue;
            this.renderTooltip(poseStack, mouseX, mouseY, stack.getDisplayName().getString());
        }
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
        boolean valid;
        boolean bl = valid = type != ClickType.QUICK_MOVE && this.f_96541_.f_91074_.f_36096_.m_142621_().m_41619_();
        if (valid && slot instanceof FilterSlot && slot.m_6659_() && ((FilterSlot)slot).isSizeAllowed()) {
            if (!slot.m_7993_().m_41619_()) {
                if (((FilterSlot)slot).isAlternativesAllowed() && BaseScreen.m_96637_()) {
                    this.f_96541_.m_91152_((Screen)new AlternativesScreen((Screen)this, (Player)this.f_96541_.f_91074_, ALTERNATIVES_TEXT, slot.m_7993_(), slot.getSlotIndex()));
                } else {
                    this.f_96541_.m_91152_((Screen)new ItemAmountScreen(this, (Player)this.f_96541_.f_91074_, slot.f_40219_, slot.m_7993_(), Math.min(slot.m_6641_(), slot.m_7993_().m_41741_()), ((FilterSlot)slot).isAlternativesAllowed() ? parent -> new AlternativesScreen((Screen)parent, (Player)this.f_96541_.f_91074_, ALTERNATIVES_TEXT, slot.m_7993_(), slot.getSlotIndex()) : null));
                }
            }
        } else if (valid && slot instanceof FluidFilterSlot && slot.m_6659_() && ((FluidFilterSlot)slot).isSizeAllowed()) {
            FluidStack stack = ((FluidFilterSlot)slot).getFluidInventory().getFluid(slot.getSlotIndex());
            if (!stack.isEmpty()) {
                if (((FluidFilterSlot)slot).isAlternativesAllowed() && BaseScreen.m_96637_()) {
                    this.f_96541_.m_91152_((Screen)new AlternativesScreen((Screen)this, (Player)this.f_96541_.f_91074_, ALTERNATIVES_TEXT, stack, slot.getSlotIndex()));
                } else {
                    this.f_96541_.m_91152_((Screen)new FluidAmountScreen(this, (Player)this.f_96541_.f_91074_, slot.f_40219_, stack, ((FluidFilterSlot)slot).getFluidInventory().getMaxAmount(), ((FluidFilterSlot)slot).isAlternativesAllowed() ? parent -> new AlternativesScreen((Screen)this, (Player)this.f_96541_.f_91074_, ALTERNATIVES_TEXT, stack, slot.getSlotIndex()) : null));
                }
            } else {
                super.m_6597_(slot, slotId, mouseButton, type);
            }
        } else {
            super.m_6597_(slot, slotId, mouseButton, type);
        }
    }

    public CheckboxWidget addCheckBox(int x, int y, Component text, boolean checked, Consumer<Checkbox> onPress) {
        CheckboxWidget checkBox = new CheckboxWidget(x, y, text, checked, onPress);
        this.m_142416_((GuiEventListener)checkBox);
        return checkBox;
    }

    public Button addButton(int x, int y, int w, int h, Component text, boolean enabled, boolean visible, Button.OnPress onPress) {
        Button button = new Button(x, y, w, h, text, onPress);
        button.f_93623_ = enabled;
        button.f_93624_ = visible;
        this.m_142416_((GuiEventListener)button);
        return button;
    }

    public void addSideButton(SideButton button) {
        button.f_93620_ = this.f_97735_ - button.m_5711_() - 2;
        button.f_93621_ = this.f_97736_ + this.sideButtonY;
        this.sideButtonY += button.m_93694_() + 2;
        this.sideButtons.add(button);
        this.m_142416_((GuiEventListener)button);
    }

    public List<SideButton> getSideButtons() {
        return this.sideButtons;
    }

    public void bindTexture(String namespace, String filenameInTexturesFolder) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_CACHE.computeIfAbsent(namespace + ":" + filenameInTexturesFolder, newId -> new ResourceLocation(namespace, "textures/" + filenameInTexturesFolder)));
    }

    public void renderItem(PoseStack poseStack, int x, int y, ItemStack stack) {
        this.renderItem(poseStack, x, y, stack, false, null, 0);
    }

    public void renderItem(PoseStack poseStack, int x, int y, ItemStack stack, boolean overlay, @Nullable String text, int textColor) {
        try {
            this.m_93250_(100);
            this.f_96542_.f_115093_ = 100.0f;
            this.f_96542_.m_115123_(stack, x, y);
            if (overlay) {
                this.f_96542_.m_115174_(this.f_96547_, stack, x, y, "");
            }
            this.m_93250_(0);
            this.f_96542_.f_115093_ = 0.0f;
            if (text != null) {
                this.renderQuantity(poseStack, x, y, text, textColor);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Couldn't render stack: {}", (Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
        }
    }

    public void renderQuantity(PoseStack poseStack, int x, int y, String qty, int color) {
        boolean large = this.f_96541_.m_91390_() || RS.CLIENT_CONFIG.getGrid().getLargeFont();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 300.0);
        if (!large) {
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
        }
        this.f_96547_.m_92750_(poseStack, qty, (float)((large ? 16 : 30) - this.f_96547_.m_92895_(qty)), large ? 8.0f : 22.0f, color);
        poseStack.m_85849_();
    }

    public void renderString(PoseStack poseStack, int x, int y, String message) {
        this.renderString(poseStack, x, y, message, RenderSettings.INSTANCE.getPrimaryColor());
    }

    public void renderString(PoseStack poseStack, int x, int y, String message, int color) {
        this.f_96547_.m_92883_(poseStack, message, (float)x, (float)y, color);
    }

    public void renderTooltip(PoseStack poseStack, int x, int y, String lines) {
        this.renderTooltip(poseStack, ItemStack.f_41583_, x, y, lines);
    }

    public void renderTooltip(PoseStack poseStack, @Nonnull ItemStack stack, int x, int y, String lines) {
        this.renderTooltip(poseStack, stack, x, y, Arrays.stream(lines.split("\n")).map(Component::m_237113_).collect(Collectors.toList()));
    }

    public void renderTooltip(PoseStack poseStack, @Nonnull ItemStack stack, int x, int y, List<Component> lines) {
        this.renderComponentTooltip(poseStack, lines, x, y, stack);
    }

    protected void onPreInit() {
    }

    public abstract void onPostInit(int var1, int var2);

    public abstract void tick(int var1, int var2);

    public abstract void renderBackground(PoseStack var1, int var2, int var3, int var4, int var5);

    public abstract void renderForeground(PoseStack var1, int var2, int var3);
}

