/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.container.FilterContainerMenu;
import com.refinedmods.refinedstorage.item.FilterItem;
import com.refinedmods.refinedstorage.network.FilterUpdateMessage;
import com.refinedmods.refinedstorage.render.RenderSettings;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.FilterTypeSideButton;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class FilterScreen
extends BaseScreen<FilterContainerMenu> {
    private final ItemStack stack;
    private final String name;
    private int compare;
    private int mode;
    private boolean modFilter;
    private int type;
    private CheckboxWidget modFilterCheckBox;
    private Button modeButton;
    private EditBox nameField;

    public FilterScreen(FilterContainerMenu containerMenu, Inventory inventory, Component title) {
        super(containerMenu, 176, 231, inventory, title);
        this.stack = containerMenu.getFilterItem();
        this.compare = FilterItem.getCompare(containerMenu.getFilterItem());
        this.mode = FilterItem.getMode(containerMenu.getFilterItem());
        this.modFilter = FilterItem.isModFilter(containerMenu.getFilterItem());
        this.name = FilterItem.getFilterName(containerMenu.getFilterItem());
        this.type = FilterItem.getType(containerMenu.getFilterItem());
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addCheckBox(x + 7, y + 77, (Component)Component.m_237115_((String)"gui.refinedstorage.filter.compare_nbt"), (this.compare & 1) == 1, btn -> {
            this.compare ^= 1;
            this.sendUpdate();
        });
        this.modFilterCheckBox = this.addCheckBox(0, y + 71 + 25, (Component)Component.m_237115_((String)"gui.refinedstorage.filter.mod_filter"), this.modFilter, btn -> {
            this.modFilter = !this.modFilter;
            this.sendUpdate();
        });
        this.modeButton = this.addButton(x + 7, y + 71 + 21, 0, 20, (Component)Component.m_237113_((String)""), true, true, btn -> {
            this.mode = this.mode == 0 ? 1 : 0;
            this.updateModeButton(this.mode);
            this.sendUpdate();
        });
        this.updateModeButton(this.mode);
        Objects.requireNonNull(this.f_96547_);
        this.nameField = new EditBox(this.f_96547_, x + 34, y + 121, 131, 9, (Component)Component.m_237113_((String)""));
        this.nameField.m_94144_(this.name);
        this.nameField.m_94182_(false);
        this.nameField.m_94194_(true);
        this.nameField.m_94190_(true);
        this.nameField.m_94178_(false);
        this.nameField.m_94202_(RenderSettings.INSTANCE.getSecondaryColor());
        this.nameField.m_94151_(content -> this.sendUpdate());
        this.m_142416_((GuiEventListener)this.nameField);
        this.addSideButton(new FilterTypeSideButton(this));
    }

    private void updateModeButton(int mode) {
        MutableComponent text = mode == 0 ? Component.m_237115_((String)"sidebutton.refinedstorage.mode.whitelist") : Component.m_237115_((String)"sidebutton.refinedstorage.mode.blacklist");
        this.modeButton.m_93674_(this.f_96547_.m_92895_(text.getString()) + 12);
        this.modeButton.m_93666_((Component)text);
        this.modFilterCheckBox.f_93620_ = this.modeButton.f_93620_ + this.modeButton.m_5711_() + 4;
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        if (this.nameField.m_7933_(key, scanCode, modifiers) || this.nameField.m_94204_()) {
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    @Override
    public void tick(int x, int y) {
    }

    @Override
    public void renderBackground(PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/filter.png");
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY) {
        this.renderString(poseStack, 7, 7, this.f_96539_.getString());
        this.renderString(poseStack, 7, 137, I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]));
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
        FilterItem.setType(this.stack, type);
    }

    public void sendUpdate() {
        RS.NETWORK_HANDLER.sendToServer(new FilterUpdateMessage(this.compare, this.mode, this.modFilter, this.nameField.m_94155_(), this.type));
    }
}

