/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid.filtering;

import com.refinedmods.refinedstorage.api.util.IFilter;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.screen.grid.stack.FluidGridStack;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import com.refinedmods.refinedstorage.screen.grid.stack.ItemGridStack;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FilterGridFilter
implements Predicate<IGridStack> {
    private final List<IFilter> filters;

    public FilterGridFilter(List<IFilter> filters) {
        this.filters = filters;
    }

    @Override
    public boolean test(IGridStack stack) {
        if (this.filters.isEmpty()) {
            return true;
        }
        int lastMode = 0;
        for (IFilter filter : this.filters) {
            String stackInFilterModId;
            ResourceLocation stackInFilterRegistryName;
            ItemStack stackInFilter;
            lastMode = filter.getMode();
            if (stack instanceof ItemGridStack && filter.getStack() instanceof ItemStack) {
                stackInFilter = (ItemStack)filter.getStack();
                if (filter.isModFilter()) {
                    String stackModId = stack.getModId();
                    String filterModId = stackInFilter.m_41720_().getCreatorModId(stackInFilter);
                    if (filterModId == null || !filterModId.equals(stackModId)) continue;
                    return filter.getMode() == 0;
                }
                if (!API.instance().getComparer().isEqual(((ItemGridStack)stack).getStack(), stackInFilter, filter.getCompare())) continue;
                return filter.getMode() == 0;
            }
            if (!(stack instanceof FluidGridStack) || !(filter.getStack() instanceof FluidStack)) continue;
            stackInFilter = (FluidStack)filter.getStack();
            if (!(filter.isModFilter() ? (stackInFilterRegistryName = ForgeRegistries.FLUIDS.getKey((Object)stackInFilter.getFluid())) != null && (stackInFilterModId = stackInFilterRegistryName.m_135827_()).equalsIgnoreCase(stack.getModId()) : API.instance().getComparer().isEqual(((FluidGridStack)stack).getStack(), (FluidStack)stackInFilter, filter.getCompare()))) continue;
            return filter.getMode() == 0;
        }
        return lastMode != 0;
    }
}

