/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.client.model;

import cech12.bucketlib.api.item.UniversalBucketItem;
import cech12.bucketlib.util.BucketLibUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.DynamicFluidContainerModel;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class UniversalBucketModel
implements IUnbakedGeometry<UniversalBucketModel> {
    public static final ResourceLocation MISSING_LOWER_CONTENT = new ResourceLocation("bucketlib", "missing_lower_content");
    private static final Map<ResourceLocation, ResourceLocation> TEXTURE_MAP = Maps.newHashMap();
    private static final Transformation DEPTH_OFFSET_TRANSFORM = new Transformation(Vector3f.f_176763_, Quaternion.f_80118_, new Vector3f(1.0f, 1.0f, 1.002f), Quaternion.f_80118_);
    public static final Material MISSING_LOWER_CONTENT_MATERIAL = new Material(InventoryMenu.f_39692_, UniversalBucketModel.getContentTexture(MISSING_LOWER_CONTENT));
    @Nonnull
    private final Fluid fluid;
    @Nullable
    private final ResourceLocation otherContent;
    private final boolean isCracked;
    private final boolean isLower;

    public UniversalBucketModel(@Nonnull Fluid fluid, @Nullable ResourceLocation otherContent, boolean isCracked, boolean isLower) {
        this.fluid = fluid;
        this.otherContent = otherContent;
        this.isCracked = isCracked;
        this.isLower = isLower;
    }

    public UniversalBucketModel withFluid(Fluid newFluid, boolean isCracked) {
        return new UniversalBucketModel(newFluid, null, isCracked, false);
    }

    public UniversalBucketModel withOtherContent(ResourceLocation otherContent, boolean isCracked, boolean isLower) {
        return new UniversalBucketModel(Fluids.f_76191_, otherContent, isCracked, isLower);
    }

    public static ResourceLocation getContentTexture(ResourceLocation otherContentLocation) {
        ResourceLocation texture = TEXTURE_MAP.get(otherContentLocation);
        if (texture == null) {
            String textureLocation = String.format("item/bucket_content/%s", otherContentLocation.m_135815_());
            texture = new ResourceLocation(otherContentLocation.m_135827_(), textureLocation);
            TEXTURE_MAP.put(otherContentLocation, texture);
        }
        return texture;
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite templateSprite;
        TextureAtlasSprite particleSprite;
        Material particleLocation = owner.hasMaterial("particle") ? owner.getMaterial("particle") : null;
        Material baseLocation = null;
        if (this.isLower) {
            if (this.isCracked && owner.hasMaterial("crackedLowerBase")) {
                baseLocation = owner.getMaterial("crackedLowerBase");
            }
            if (baseLocation == null && owner.hasMaterial("lowerBase")) {
                baseLocation = owner.getMaterial("lowerBase");
            }
        } else {
            if (this.isCracked && owner.hasMaterial("crackedBase")) {
                baseLocation = owner.getMaterial("crackedBase");
            }
            if (baseLocation == null && owner.hasMaterial("base")) {
                baseLocation = owner.getMaterial("base");
            }
        }
        Material otherContentLocation = null;
        Material fluidMaskLocation = null;
        if (this.otherContent != null) {
            otherContentLocation = new Material(InventoryMenu.f_39692_, UniversalBucketModel.getContentTexture(this.otherContent));
        } else if (this.fluid != Fluids.f_76191_) {
            if (this.isCracked && owner.hasMaterial("crackedFluidMask")) {
                fluidMaskLocation = owner.getMaterial("crackedFluidMask");
            }
            if (fluidMaskLocation == null && owner.hasMaterial("fluidMask")) {
                fluidMaskLocation = owner.getMaterial("fluidMask");
            }
        }
        TextureAtlasSprite baseSprite = baseLocation != null ? spriteGetter.apply(baseLocation) : null;
        TextureAtlasSprite otherContentSprite = null;
        if (otherContentLocation != null) {
            otherContentSprite = spriteGetter.apply(otherContentLocation);
            if (MissingTextureAtlasSprite.m_118071_().equals((Object)otherContentSprite.m_118413_())) {
                otherContentSprite = spriteGetter.apply(MISSING_LOWER_CONTENT_MATERIAL);
            }
        }
        TextureAtlasSprite fluidSprite = this.fluid != Fluids.f_76191_ ? spriteGetter.apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)IClientFluidTypeExtensions.of((Fluid)this.fluid).getStillTexture())) : null;
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = baseSprite;
        }
        if (particleSprite == null) {
            particleSprite = otherContentSprite;
        }
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (this.fluid != Fluids.f_76191_ && this.fluid.getFluidType().isLighterThanAir()) {
            modelState = new SimpleModelState(modelState.m_6189_().m_121096_(new Transformation(null, new Quaternion(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)owner).withGui3d(false).withUseBlockLight(false).build(modelLocation);
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)particleSprite, (ItemOverrides)new ContainedFluidOverrideHandler(overrides, bakery, (IGeometryBakingContext)itemContext, this), (ItemTransforms)owner.getTransforms());
        RenderTypeGroup normalRenderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)false);
        if (baseSprite != null) {
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)baseSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> baseSprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        }
        if (otherContentSprite != null) {
            SimpleModelState transformedState = new SimpleModelState(modelState.m_6189_().m_121096_(DEPTH_OFFSET_TRANSFORM), modelState.m_7538_());
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)2, (TextureAtlasSprite)otherContentSprite);
            TextureAtlasSprite finalOtherContentSprite = otherContentSprite;
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> finalOtherContentSprite, (ModelState)transformedState, (ResourceLocation)modelLocation);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        } else if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            SimpleModelState transformedState = new SimpleModelState(modelState.m_6189_().m_121096_(DEPTH_OFFSET_TRANSFORM), modelState.m_7538_());
            List unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)1, (TextureAtlasSprite)templateSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> fluidSprite, (ModelState)transformedState, (ResourceLocation)modelLocation);
            boolean emissive = this.fluid.getFluidType().getLightLevel() > 0;
            RenderTypeGroup renderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)emissive);
            if (emissive) {
                QuadTransformers.settingEmissivity((int)this.fluid.getFluidType().getLightLevel()).processInPlace(quads);
            }
            modelBuilder.addQuads(renderTypes, (Collection)quads);
        }
        modelBuilder.setParticle(particleSprite);
        return modelBuilder.build();
    }

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet();
        if (owner.hasMaterial("particle")) {
            textures.add(owner.getMaterial("particle"));
        }
        if (owner.hasMaterial("base")) {
            textures.add(owner.getMaterial("base"));
        }
        if (owner.hasMaterial("lowerBase")) {
            textures.add(owner.getMaterial("lowerBase"));
        }
        if (owner.hasMaterial("fluidMask")) {
            textures.add(owner.getMaterial("fluidMask"));
        }
        if (owner.hasMaterial("crackedBase")) {
            textures.add(owner.getMaterial("crackedBase"));
        }
        if (owner.hasMaterial("crackedLowerBase")) {
            textures.add(owner.getMaterial("crackedLowerBase"));
        }
        if (owner.hasMaterial("crackedFluidMask")) {
            textures.add(owner.getMaterial("crackedFluidMask"));
        }
        return textures;
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrides {
        private static final ResourceLocation REBAKE_LOCATION = new ResourceLocation("bucketlib", "bucket_override");
        private final Map<String, BakedModel> cache = Maps.newHashMap();
        private final ItemOverrides nested;
        private final ModelBakery bakery;
        private final IGeometryBakingContext owner;
        private final UniversalBucketModel parent;
        private Integer upperBreakTemperature = null;
        private Integer lowerBreakTemperature = null;

        private ContainedFluidOverrideHandler(ItemOverrides nested, ModelBakery bakery, IGeometryBakingContext owner, UniversalBucketModel parent) {
            this.nested = nested;
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        @Nullable
        public BakedModel m_173464_(@Nonnull BakedModel originalModel, @Nonnull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int number) {
            BakedModel overridden = this.nested.m_173464_(originalModel, stack, world, entity, number);
            if (overridden != originalModel) {
                return overridden;
            }
            Item item = stack.m_41720_();
            if (item instanceof UniversalBucketItem) {
                BakedModel bakedModel;
                UniversalBucketItem bucket = (UniversalBucketItem)item;
                boolean containsEntityType = false;
                String content = BucketLibUtil.getEntityTypeString(stack);
                if (content != null) {
                    containsEntityType = true;
                } else {
                    content = BucketLibUtil.getContentString(stack);
                }
                Fluid fluid = null;
                if (content == null) {
                    fluid = BucketLibUtil.getFluid(stack);
                    ResourceLocation location = ForgeRegistries.FLUIDS.getKey((Object)fluid);
                    String string = content = location != null ? location.toString() : null;
                }
                if (!Objects.equals(this.upperBreakTemperature, bucket.getUpperBreakTemperature()) || !Objects.equals(this.lowerBreakTemperature, bucket.getLowerBreakTemperature())) {
                    this.upperBreakTemperature = bucket.getUpperBreakTemperature();
                    this.lowerBreakTemperature = bucket.getLowerBreakTemperature();
                    this.cache.clear();
                }
                if ((bakedModel = this.cache.get(content)) == null && content != null) {
                    boolean isCracked = bucket.isCracked(stack);
                    UniversalBucketModel unbaked = fluid == null ? this.parent.withOtherContent(new ResourceLocation(content), isCracked, containsEntityType) : this.parent.withFluid(fluid, isCracked);
                    bakedModel = unbaked.bake(this.owner, this.bakery, Material::m_119204_, (ModelState)BlockModelRotation.X0_Y0, this, REBAKE_LOCATION);
                    this.cache.put(content, bakedModel);
                }
                return bakedModel;
            }
            return originalModel;
        }
    }

    public static final class Loader
    implements IGeometryLoader<UniversalBucketModel> {
        public static final Loader INSTANCE = new Loader();

        @Nonnull
        public UniversalBucketModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            return new UniversalBucketModel(Fluids.f_76191_, null, false, false);
        }
    }
}

