/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.dimensions.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.serialization.Lifecycle;
import dev.ftb.mods.ftbteamdimensions.FTBDimensionsConfig;
import dev.ftb.mods.ftbteamdimensions.FTBTeamDimensions;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.DimensionStorage;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.chunkgen.ChunkGenerators;
import dev.ftb.mods.ftbteamdimensions.dimensions.prebuilt.PrebuiltStructure;
import dev.ftb.mods.ftbteamdimensions.dimensions.prebuilt.PrebuiltStructureManager;
import dev.ftb.mods.ftbteamdimensions.net.UpdateDimensionsList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.io.FileUtils;

public class DynamicDimensionManager {
    public static ServerLevel create(MinecraftServer server, ResourceKey<Level> key, ResourceLocation prebuiltStructureId) {
        Map map = server.forgeGetWorldMap();
        ServerLevel existingLevel = (ServerLevel)map.get(key);
        if (existingLevel != null) {
            return existingLevel;
        }
        RegistryAccess.Frozen registryAccess = server.m_206579_();
        ServerLevel overworld = Objects.requireNonNull(server.m_129880_(Level.f_46428_));
        ResourceLocation dimensionTypeId = PrebuiltStructureManager.getServerInstance().getStructure(prebuiltStructureId).map(PrebuiltStructure::dimensionType).orElse(PrebuiltStructure.DEFAULT_DIMENSION_TYPE);
        ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)key.m_135782_());
        Holder typeHolder = registryAccess.m_175515_(Registry.f_122818_).m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)dimensionTypeId));
        ChunkGenerator chunkGenerator = ((ChunkGenerators)((Object)FTBDimensionsConfig.COMMON_GENERAL.chunkGenerator.get())).makeGenerator((RegistryAccess)registryAccess, prebuiltStructureId);
        LevelStem dimension = new LevelStem(typeHolder, chunkGenerator);
        ChunkProgressListener chunkProgressListener = server.f_129756_.m_9620_(11);
        WorldData worldData = server.m_129910_();
        WorldGenSettings worldGenSettings = worldData.m_5961_();
        DerivedLevelData levelData = new DerivedLevelData(worldData, worldData.m_5996_());
        ((MappedRegistry)worldGenSettings.m_204655_()).m_203505_(dimensionKey, (Object)dimension, Lifecycle.stable());
        ServerLevel newWorld = new ServerLevel(server, server.f_129738_, server.f_129744_, (ServerLevelData)levelData, key, dimension, chunkProgressListener, worldGenSettings.m_64668_(), BiomeManager.m_47877_((long)worldGenSettings.m_64619_()), (List)ImmutableList.of(), false);
        overworld.m_6857_().m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(newWorld.m_6857_()));
        map.put(key, newWorld);
        server.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post((Event)new LevelEvent((LevelAccessor)newWorld));
        new UpdateDimensionsList(key, true).sendToAll(server);
        return newWorld;
    }

    public static ServerLevel destroy(MinecraftServer server, ResourceKey<Level> key) {
        WorldGenSettings worldGenSettings = server.m_129910_().m_5961_();
        ServerLevel overworld = Objects.requireNonNull(server.m_129880_(Level.f_46428_));
        Path dimensionPath = server.f_129744_.m_197394_(key);
        ServerLevel removedLevel = (ServerLevel)server.forgeGetWorldMap().remove(key);
        if (removedLevel == null) {
            return null;
        }
        for (ServerPlayer player : Lists.newArrayList((Iterable)removedLevel.m_6907_())) {
            BlockPos destinationPos = player.m_8961_();
            if (destinationPos == null) {
                destinationPos = overworld.m_220360_();
            }
            float respawnAngle = player.m_8962_();
            player.m_8999_(overworld, (double)destinationPos.m_123341_(), (double)destinationPos.m_123342_(), (double)destinationPos.m_123343_(), respawnAngle, 0.0f);
        }
        removedLevel.m_8643_(null, false, removedLevel.m_7441_());
        MinecraftForge.EVENT_BUS.post((Event)new LevelEvent((LevelAccessor)removedLevel));
        WorldBorder overworldBorder = overworld.m_6857_();
        WorldBorder removedWorldBorder = removedLevel.m_6857_();
        overworldBorder.f_61905_.stream().filter(listener -> {
            if (!(listener instanceof BorderChangeListener.DelegateBorderChangeListener)) return false;
            BorderChangeListener.DelegateBorderChangeListener l = (BorderChangeListener.DelegateBorderChangeListener)listener;
            if (removedWorldBorder != l.f_61864_) return false;
            return true;
        }).findFirst().ifPresent(arg_0 -> ((WorldBorder)overworldBorder).m_156096_(arg_0));
        Registry oldRegistry = worldGenSettings.m_204655_();
        MappedRegistry newRegistry = new MappedRegistry(Registry.f_122820_, oldRegistry.m_7837_(), null);
        for (Map.Entry entry : oldRegistry.m_6579_()) {
            ResourceKey oldKey = (ResourceKey)entry.getKey();
            ResourceKey oldLevelKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)oldKey.m_135782_());
            LevelStem dimension = (LevelStem)entry.getValue();
            if (dimension == null || oldLevelKey == key) continue;
            newRegistry.m_203505_(oldKey, (Object)dimension, oldRegistry.m_6228_((Object)dimension));
        }
        worldGenSettings.f_64605_ = newRegistry;
        if (Files.exists(dimensionPath, new LinkOption[0])) {
            try {
                FileUtils.deleteDirectory((File)dimensionPath.toFile());
                FTBTeamDimensions.LOGGER.info("Deleted archived dimension {} from disk", (Object)dimensionPath);
            }
            catch (IOException e) {
                FTBTeamDimensions.LOGGER.error("Failed to delete dimension file for {} at {}", key, (Object)dimensionPath, (Object)e);
            }
        }
        server.markWorldsDirty();
        new UpdateDimensionsList(key, false).sendToAll(server);
        return removedLevel;
    }

    public static boolean teleport(ServerPlayer player, ResourceKey<Level> key) {
        return DynamicDimensionManager.teleport(player, key, null);
    }

    public static boolean teleport(ServerPlayer player, ResourceKey<Level> key, BlockPos destPos) {
        ServerLevel level = player.f_8924_.m_129880_(key);
        if (level != null) {
            if (key.equals((Object)Level.f_46428_)) {
                BlockPos lobbySpawnPos = DimensionStorage.get(player.f_8924_).getLobbySpawnPos();
                BlockPos pos = Objects.requireNonNullElse(destPos, lobbySpawnPos);
                player.m_8999_(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.01, (double)pos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
            } else {
                Vec3 vec;
                if (destPos == null) {
                    vec = new Vec3(0.5, 1.1, 0.5);
                    BlockPos respawnPosition = player.m_8961_();
                    if (player.m_8963_().equals(key) && respawnPosition != null) {
                        vec = vec.m_82549_(new Vec3((double)respawnPosition.m_123341_(), (double)respawnPosition.m_123342_(), (double)respawnPosition.m_123343_()));
                    } else {
                        BlockPos levelSharedSpawn = DimensionStorage.get(player.f_8924_).getDimensionSpawnLocation(level.m_46472_().m_135782_());
                        if (levelSharedSpawn == null) {
                            levelSharedSpawn = BlockPos.f_121853_;
                        }
                        vec = vec.m_82549_(new Vec3((double)levelSharedSpawn.m_123341_(), (double)levelSharedSpawn.m_123342_(), (double)levelSharedSpawn.m_123343_()));
                    }
                } else {
                    vec = Vec3.m_82512_((Vec3i)destPos);
                }
                FTBTeamDimensions.LOGGER.debug("teleport {} to {} in {}", (Object)player.m_36316_().getName(), (Object)vec, (Object)key.m_135782_());
                ChunkPos chunkpos = new ChunkPos(new BlockPos(vec.f_82479_, vec.f_82480_, vec.f_82481_));
                level.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)player.m_19879_());
                player.m_8127_();
                player.m_8999_(level, vec.f_82479_, vec.f_82480_, vec.f_82481_, player.m_146908_(), player.m_146909_());
            }
            return true;
        }
        FTBTeamDimensions.LOGGER.error("Failed to teleport {} to {} (bad level key)", (Object)player.m_6302_(), (Object)key.m_135782_());
        return false;
    }
}

