/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.dimensions.level.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbteamdimensions.FTBTeamDimensions;
import dev.ftb.mods.ftbteamdimensions.dimensions.DimensionUtils;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.PrebuiltStructureProvider;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.structure.StartStructurePiece;
import dev.ftb.mods.ftbteamdimensions.dimensions.prebuilt.PrebuiltStructureManager;
import dev.ftb.mods.ftbteamdimensions.registry.ModWorldGen;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StartStructure
extends Structure {
    public static final Codec<StartStructure> CODEC = RecordCodecBuilder.mapCodec(x -> x.group((App)StartStructure.m_226567_((RecordCodecBuilder.Instance)x), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(s -> s.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(s -> s.projectStartToHeightmap)).apply((Applicative)x, StartStructure::new)).codec();
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;

    private StartStructure(Structure.StructureSettings settings, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap) {
        super(settings);
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkGenerator chunkGenerator = context.f_226622_();
        if (!(chunkGenerator instanceof PrebuiltStructureProvider)) {
            return Optional.empty();
        }
        PrebuiltStructureProvider provider = (PrebuiltStructureProvider)chunkGenerator;
        PrebuiltStructureManager mgr = PrebuiltStructureManager.getServerInstance();
        Optional<Structure.GenerationStub> res = mgr.getStructure(provider.getPrebuiltStructureId()).map(start -> {
            StructureTemplate template = context.f_226625_().m_230359_(start.structureLocation());
            BlockPos spawnPos = DimensionUtils.locateSpawn(template);
            int x = -spawnPos.m_123341_();
            int y = -spawnPos.m_123342_();
            int z = -spawnPos.m_123343_();
            BlockPos blockPos = new BlockPos(x, y + start.height(), z);
            return Optional.of(new Structure.GenerationStub(blockPos, builder -> builder.m_142679_((StructurePiece)new StartStructurePiece(context.f_226625_(), start.structureLocation(), blockPos, template))));
        }).orElse(Optional.empty());
        if (res.isEmpty()) {
            FTBTeamDimensions.LOGGER.warn("Unable to find [{}] in the prebuilt structure list", (Object)provider.getPrebuiltStructureId());
        }
        return res;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ModWorldGen.START_STRUCTURE.get();
    }
}

