/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.dimensions.prebuilt;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import dev.ftb.mods.ftbteamdimensions.dimensions.prebuilt.PrebuiltStructure;
import dev.ftb.mods.ftbteamdimensions.net.SyncPrebuiltStructures;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PrebuiltStructureManager {
    private static final PrebuiltStructureManager CLIENT_INSTANCE = new PrebuiltStructureManager();
    private static final PrebuiltStructureManager SERVER_INSTANCE = new PrebuiltStructureManager();
    private final Map<ResourceLocation, PrebuiltStructure> STRUCTURES = new ConcurrentHashMap<ResourceLocation, PrebuiltStructure>();

    public static PrebuiltStructureManager getClientInstance() {
        return CLIENT_INSTANCE;
    }

    public static PrebuiltStructureManager getServerInstance() {
        return SERVER_INSTANCE;
    }

    public Optional<PrebuiltStructure> getStructure(ResourceLocation id) {
        return Optional.ofNullable(this.STRUCTURES.get(id));
    }

    public Collection<ResourceLocation> getStructureIds() {
        return this.STRUCTURES.keySet();
    }

    public Collection<PrebuiltStructure> getStructures() {
        return this.STRUCTURES.values();
    }

    public void syncFromServer(Collection<PrebuiltStructure> structures) {
        this.STRUCTURES.clear();
        structures.forEach(s -> this.STRUCTURES.put(s.id(), (PrebuiltStructure)s));
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

        public ReloadListener() {
            super(GSON, "ftbdim_prebuilt_structures");
        }

        protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
            PrebuiltStructureManager.getServerInstance().STRUCTURES.clear();
            object.forEach((id, json) -> PrebuiltStructure.fromJson(json).ifPresent(s -> PrebuiltStructureManager.getServerInstance().STRUCTURES.put((ResourceLocation)id, (PrebuiltStructure)s)));
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                new SyncPrebuiltStructures(PrebuiltStructureManager.getServerInstance()).sendToAll(ServerLifecycleHooks.getCurrentServer());
            }
        }
    }
}

