/*
 * Decompiled with CFR 0.152.
 */
package com.song.castle_in_the_sky.utils;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityCastle
implements ICapabilitySerializable<CompoundTag> {
    private final Data data = new Data();
    private final LazyOptional<Data> dataOptional = LazyOptional.of(() -> this.data);
    public static final Capability<Data> CASTLE_CAPS = CapabilityManager.get((CapabilityToken)new CapabilityToken<Data>(){});

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CASTLE_CAPS.orEmpty(cap, this.dataOptional);
    }

    public CompoundTag serializeNBT() {
        return this.data.save();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.data.load(nbt);
    }

    public void invalidate() {
        this.dataOptional.invalidate();
    }

    public static class Data {
        private static final int INCANTATION_WARNING_CD = 200;
        private boolean incantationWarned;
        private int incantationWarningCD = 0;

        public void tick() {
            if (this.incantationWarningCD > 0) {
                --this.incantationWarningCD;
                if (this.incantationWarningCD <= 0) {
                    this.setIncantationWarned(false);
                    this.incantationWarningCD = 0;
                }
            }
        }

        public void setWarningCD() {
            this.incantationWarningCD = 200;
        }

        public void setIncantationWarned(boolean incantationWarned) {
            this.incantationWarned = incantationWarned;
        }

        public boolean isIncantationWarned() {
            return this.incantationWarned;
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("incantationWarned", this.incantationWarned);
            tag.m_128405_("incantationWarningCD", this.incantationWarningCD);
            return tag;
        }

        public void load(CompoundTag tag) {
            this.incantationWarned = tag.m_128471_("incantationWarned");
            this.incantationWarningCD = tag.m_128451_("incantationWarningCD");
        }
    }
}

