/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command.data;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.core.CMCommands;
import dev.compactmods.machines.command.argument.RoomPositionArgument;
import dev.compactmods.machines.dimension.Dimension;
import dev.compactmods.machines.dimension.MissingDimensionException;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.room.data.CompactRoomData;
import dev.compactmods.machines.tunnel.graph.TunnelConnectionGraph;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.CsvOutput;
import net.minecraft.world.level.ChunkPos;

public class CMTunnelDataExportCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> makeTunnelCsv() {
        RequiredArgumentBuilder chunk = (RequiredArgumentBuilder)Commands.m_82129_((String)"room", (ArgumentType)RoomPositionArgument.room()).executes(CMTunnelDataExportCommand::exec);
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tunnels").requires(cs -> cs.m_6761_(2))).executes(CMTunnelDataExportCommand::execAll)).then((ArgumentBuilder)chunk);
    }

    private static int execAll(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        MinecraftServer serv = src.m_81377_();
        ServerLevel compact = serv.m_129880_(Dimension.COMPACT_DIMENSION);
        CompactRoomData rooms = CompactRoomData.get(compact);
        File outdir = src.m_81377_().m_129971_("compactmachines");
        Path out = outdir.toPath().resolve("tunnels.csv").toAbsolutePath();
        try {
            Files.createDirectories(outdir.toPath(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(out, new OpenOption[0]);
            CsvOutput builder = CMTunnelDataExportCommand.makeTunnelCsvOut(writer);
            rooms.stream().forEach(roomChunk -> {
                try {
                    CMTunnelDataExportCommand.writeRoomTunnels(compact, roomChunk, builder);
                }
                catch (MissingDimensionException e) {
                    CompactMachines.LOGGER.error((Object)e);
                }
            });
            writer.close();
        }
        catch (IOException e) {
            CompactMachines.LOGGER.error((Object)e);
            src.m_81352_((Component)TranslationUtil.command(CMCommands.FAILED_CMD_FILE_ERROR));
            return -1;
        }
        return 0;
    }

    public static int exec(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = src.m_81375_();
        ChunkPos room = RoomPositionArgument.get(ctx, "room");
        ServerLevel compactDim = src.m_81377_().m_129880_(Dimension.COMPACT_DIMENSION);
        File outdir = src.m_81377_().m_129971_("compactmachines");
        Path out = outdir.toPath().resolve(String.format("tunnels_%s_%s.csv", room.f_45578_, room.f_45579_)).toAbsolutePath();
        try {
            Files.createDirectories(outdir.toPath(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(out, new OpenOption[0]);
            CsvOutput builder = CMTunnelDataExportCommand.makeTunnelCsvOut(writer);
            CMTunnelDataExportCommand.writeRoomTunnels(compactDim, room, builder);
            writer.close();
        }
        catch (IOException e) {
            CompactMachines.LOGGER.error((Object)e);
            src.m_81352_((Component)TranslationUtil.command(CMCommands.FAILED_CMD_FILE_ERROR));
            return -1;
        }
        catch (MissingDimensionException e) {
            CompactMachines.LOGGER.error((Object)e);
        }
        return 0;
    }

    @Nonnull
    private static CsvOutput makeTunnelCsvOut(BufferedWriter writer) throws IOException {
        return CsvOutput.m_13619_().m_13630_("type").m_13630_("side").m_13630_("pos_x").m_13630_("pos_y").m_13630_("pos_z").m_13630_("machine_id").m_13628_((Writer)writer);
    }

    private static void writeRoomTunnels(ServerLevel compactDim, ChunkPos room, CsvOutput builder) throws MissingDimensionException {
        TunnelConnectionGraph graph = TunnelConnectionGraph.forRoom(compactDim, room);
        graph.tunnels().forEach(info -> {
            BlockPos pos = info.location();
            try {
                builder.m_13624_(new Object[]{info.type().toString(), info.side().m_7912_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), info.machine()});
            }
            catch (IOException e) {
                CompactMachines.LOGGER.warn("Error writing tunnel record.", (Throwable)e);
            }
        });
    }
}

