/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command.subcommand;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.compactmods.machines.api.core.CMCommands;
import dev.compactmods.machines.dimension.Dimension;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.machine.graph.DimensionMachineGraph;
import dev.compactmods.machines.room.data.CompactRoomData;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;

public class CMSummarySubcommand {
    public static ArgumentBuilder<CommandSourceStack, ?> make() {
        return Commands.m_82127_((String)"summary").executes(CMSummarySubcommand::exec);
    }

    private static int exec(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        MinecraftServer serv = src.m_81377_();
        ServerLevel compactLevel = serv.m_129880_(Dimension.COMPACT_DIMENSION);
        if (compactLevel != null) {
            src.m_81354_((Component)TranslationUtil.command(CMCommands.LEVEL_REGISTERED).m_130940_(ChatFormatting.DARK_GREEN), false);
        } else {
            src.m_81354_((Component)TranslationUtil.command(CMCommands.LEVEL_NOT_FOUND).m_130940_(ChatFormatting.RED), false);
        }
        HashMap levelCounts = new HashMap();
        serv.m_129785_().forEach(sl -> {
            DimensionMachineGraph machineData = DimensionMachineGraph.forDimension(sl);
            long numRegistered = machineData.getMachines().count();
            if (numRegistered > 0L) {
                src.m_81354_((Component)TranslationUtil.command(CMCommands.MACHINE_REG_DIM, sl.m_46472_().toString(), numRegistered), false);
                levelCounts.put(sl.m_46472_(), numRegistered);
            }
        });
        long grandTotal = levelCounts.values().stream().reduce(0L, Long::sum);
        src.m_81354_((Component)TranslationUtil.command(CMCommands.MACHINE_REG_TOTAL, grandTotal).m_130940_(ChatFormatting.GOLD), false);
        CompactRoomData roomData = CompactRoomData.get(compactLevel);
        long numRegistered = roomData.stream().count();
        src.m_81354_((Component)TranslationUtil.command(CMCommands.ROOM_REG_COUNT, numRegistered), false);
        return 0;
    }
}

