/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.network;

import dev.compactmods.machines.dimension.MissingDimensionException;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.room.exceptions.NonexistentRoomException;
import dev.compactmods.machines.room.network.InitialRoomBlockDataPacket;
import dev.compactmods.machines.room.network.RoomNetworkHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record PlayerStartedRoomTrackingPacket(ChunkPos room) {
    public PlayerStartedRoomTrackingPacket(FriendlyByteBuf buf) {
        this(buf.m_178383_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_178341_(this.room);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        ctx.get().enqueueWork(() -> {
            try {
                StructureTemplate blocks = Rooms.getInternalBlocks(sender.f_8924_, this.room);
                RoomNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new InitialRoomBlockDataPacket(blocks));
            }
            catch (MissingDimensionException | NonexistentRoomException e) {
                e.printStackTrace();
            }
        });
        return true;
    }
}

