/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.util;

import dev.compactmods.machines.api.room.RoomSize;
import dev.compactmods.machines.wall.Walls;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class CompactStructureGenerator {
    public static AABB getWallBounds(RoomSize size, BlockPos cubeCenter, Direction wall) {
        boolean horiz;
        int s = size.getInternalSize() / 2;
        boolean bl = horiz = wall.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL;
        if (horiz) {
            BlockPos start = cubeCenter.m_6625_(s).m_5484_(wall, s + 1);
            wallBounds = new AABB(start, start).m_82363_(0.0, (double)(s * 2 + 1), 0.0);
        } else {
            BlockPos start = cubeCenter.m_5484_(wall, s + 1);
            wallBounds = new AABB(start, start).m_82377_((double)(s + 1), 0.0, (double)(s + 1));
        }
        AABB wallBounds = switch (wall) {
            case Direction.NORTH, Direction.SOUTH -> wallBounds.m_82377_((double)(s + 1), 0.0, 0.0);
            case Direction.WEST, Direction.EAST -> wallBounds.m_82377_(0.0, 0.0, (double)(s + 1));
        };
        return wallBounds;
    }

    public static void generateCompactWall(LevelAccessor world, RoomSize size, BlockPos cubeCenter, Direction wallDirection) {
        BlockState unbreakableWall = ((Block)Walls.BLOCK_SOLID_WALL.get()).m_49966_();
        AABB wallBounds = CompactStructureGenerator.getWallBounds(size, cubeCenter, wallDirection);
        BlockPos.m_121921_((AABB)wallBounds).filter(arg_0 -> ((LevelAccessor)world).m_46859_(arg_0)).map(BlockPos::m_7949_).forEach(p -> world.m_7731_(p, unbreakableWall, 7));
    }

    public static void generateCompactStructure(LevelAccessor world, RoomSize size, BlockPos center) {
        int s = size.getInternalSize() / 2;
        BlockPos floorCenter = center.m_5484_(Direction.DOWN, s);
        BlockPos machineTopCenter = center.m_5484_(Direction.UP, s);
        AABB floorBlocks = new AABB(floorCenter, floorCenter).m_82377_((double)s, 0.0, (double)s);
        AABB machineInternal = new AABB(machineTopCenter, floorCenter).m_82377_((double)s, 0.0, (double)s);
        boolean anyAir = BlockPos.m_121921_((AABB)floorBlocks).anyMatch(arg_0 -> ((LevelAccessor)world).m_46859_(arg_0));
        if (anyAir) {
            Arrays.stream(Direction.values()).forEach(d -> CompactStructureGenerator.generateCompactWall(world, size, center, d));
            BlockPos.m_121921_((AABB)machineInternal).forEach(p -> world.m_7731_(p, Blocks.f_50016_.m_49966_(), 7));
        }
    }
}

