/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.Optional;
import me.tepis.integratednbt.NBTExtractedVariableFacade;
import me.tepis.integratednbt.NBTPath;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;

public class NBTExtractedVariableFacadeHandler
implements IVariableFacadeHandler<NBTExtractedVariableFacade> {
    private static final String KEY_SOURCE_NBT_ID = "sourceNBTId";
    private static final String KEY_EXTRACTION_PATH = "extractionPath";
    private static final String KEY_DEFAULT_NBT_ID = "defaultNBTId";
    private static NBTExtractedVariableFacadeHandler instance;

    public static NBTExtractedVariableFacadeHandler getInstance() {
        if (instance == null) {
            instance = new NBTExtractedVariableFacadeHandler();
        }
        return instance;
    }

    public ResourceLocation getUniqueName() {
        return new ResourceLocation("integratednbt", "nbt_extracted");
    }

    public NBTExtractedVariableFacade getVariableFacade(int id, CompoundTag tag) {
        int sourceNBTId = tag.m_128451_(KEY_SOURCE_NBT_ID);
        Optional<NBTPath> extractionPath = NBTPath.fromNBT(tag.m_128423_(KEY_EXTRACTION_PATH));
        byte defaultNBTId = tag.m_128445_(KEY_DEFAULT_NBT_ID);
        return new NBTExtractedVariableFacade(id, sourceNBTId, (NBTPath)extractionPath.orElse(null), defaultNBTId);
    }

    public void setVariableFacade(CompoundTag tag, NBTExtractedVariableFacade facade) {
        tag.m_128405_(KEY_SOURCE_NBT_ID, facade.getSourceNBTId());
        tag.m_128365_(KEY_EXTRACTION_PATH, (Tag)facade.getExtractionPath().toNBT());
        tag.m_128344_(KEY_DEFAULT_NBT_ID, facade.getDefaultNBTId());
    }
}

