/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.tepis.integratednbt.NBTExtractedVariableFacade;
import me.tepis.integratednbt.NBTExtractedVariableFacadeHandler;
import me.tepis.integratednbt.NBTExtractionOperator;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.NBTValueConverter;
import me.tepis.integratednbt.Texture;
import me.tepis.integratednbt.TexturePart;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum NBTExtractorOutputMode {
    REFERENCE("reference", ChatFormatting.YELLOW, Nest.GUI_TEXTURE.createPart(90, 0, 12, 12), Nest.GUI_TEXTURE.createPart(90, 12, 12, 12)){

        @Override
        public ItemStack writeItemStack(Supplier<IVariableFacade> sourceVariableFacadeSupplier, ItemStack outputVariableItemStack, Tag currentNBT, final NBTPath extractionPath, final byte defaultNBTId, BlockState blockState) {
            IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
            IVariableFacade variableFacade = sourceVariableFacadeSupplier.get();
            if (variableFacade != null) {
                final int sourceNBTId = variableFacade.getId();
                IVariableFacadeHandlerRegistry.IVariableFacadeFactory<NBTExtractedVariableFacade> factory = new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<NBTExtractedVariableFacade>(){

                    public NBTExtractedVariableFacade create(boolean generateId) {
                        return new NBTExtractedVariableFacade(generateId, sourceNBTId, extractionPath, defaultNBTId);
                    }

                    public NBTExtractedVariableFacade create(int id) {
                        return new NBTExtractedVariableFacade(id, sourceNBTId, extractionPath, defaultNBTId);
                    }
                };
                return registry.writeVariableFacadeItem(true, outputVariableItemStack, (IVariableFacadeHandler)NBTExtractedVariableFacadeHandler.getInstance(), (IVariableFacadeHandlerRegistry.IVariableFacadeFactory)factory, null, blockState);
            }
            return null;
        }
    }
    ,
    OPERATOR("operator", ChatFormatting.DARK_GREEN, Nest.GUI_TEXTURE.createPart(102, 0, 12, 12), Nest.GUI_TEXTURE.createPart(102, 12, 12, 12)){

        @Override
        public ItemStack writeItemStack(Supplier<IVariableFacade> sourceVariableFacadeSupplier, ItemStack outputVariableItemStack, Tag currentNBT, NBTPath extractionPath, byte defaultNBTId, BlockState blockState) {
            return NBTExtractorOutputMode.getVariableUsingValue((IValue)ValueTypeOperator.ValueOperator.of((IOperator)new NBTExtractionOperator(extractionPath, defaultNBTId)), outputVariableItemStack, blockState);
        }
    }
    ,
    VALUE("value", ChatFormatting.GOLD, Nest.GUI_TEXTURE.createPart(114, 0, 12, 12), Nest.GUI_TEXTURE.createPart(114, 12, 12, 12)){

        @Override
        public ItemStack writeItemStack(Supplier<IVariableFacade> sourceVariableFacadeSupplier, ItemStack outputVariableItemStack, Tag currentNBT, NBTPath extractionPath, byte defaultNBTId, BlockState blockState) {
            sourceVariableFacadeSupplier.get();
            Tag extractedNBT = extractionPath.extract(currentNBT);
            IValue value = extractedNBT == null ? NBTValueConverter.getDefaultValue(defaultNBTId) : NBTValueConverter.mapNBTToValue(extractedNBT);
            return NBTExtractorOutputMode.getVariableUsingValue(value, outputVariableItemStack, blockState);
        }
    }
    ,
    NBT_PATH("nbt_path", ChatFormatting.RED, Nest.GUI_TEXTURE.createPart(150, 0, 12, 12), Nest.GUI_TEXTURE.createPart(150, 12, 12, 12)){

        @Override
        public ItemStack writeItemStack(Supplier<IVariableFacade> sourceVariableFacadeSupplier, ItemStack outputVariableItemStack, Tag currentNBT, NBTPath extractionPath, byte defaultNBTId, BlockState blockState) {
            return NBTExtractorOutputMode.getVariableUsingValue((IValue)ValueTypeString.ValueString.of((String)extractionPath.getCyclopsNBTPath()), outputVariableItemStack, blockState);
        }
    };

    private String translationId;
    private ChatFormatting color;
    private TexturePart buttonTextureNormal;
    private TexturePart buttonTextureHover;

    private NBTExtractorOutputMode(String translationId, ChatFormatting color, TexturePart buttonTextureNormal, TexturePart buttonTextureHover) {
        this.translationId = translationId;
        this.color = color;
        this.buttonTextureNormal = buttonTextureNormal;
        this.buttonTextureHover = buttonTextureHover;
    }

    @Nullable
    private static ItemStack getVariableUsingValue(final IValue value, ItemStack outputVariableItemStack, BlockState blockState) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        if (value == null) {
            return null;
        }
        return registry.writeVariableFacadeItem(true, outputVariableItemStack, (IVariableFacadeHandler)ValueTypes.REGISTRY, (IVariableFacadeHandlerRegistry.IVariableFacadeFactory)new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IValueTypeVariableFacade>(){

            public IValueTypeVariableFacade create(boolean generateId) {
                return new ValueTypeVariableFacade(generateId, value.getType(), value);
            }

            public IValueTypeVariableFacade create(int id) {
                return new ValueTypeVariableFacade(id, value.getType(), value);
            }
        }, null, blockState);
    }

    public TexturePart getButtonTextureNormal() {
        return this.buttonTextureNormal;
    }

    public TexturePart getButtonTextureHover() {
        return this.buttonTextureHover;
    }

    public abstract ItemStack writeItemStack(Supplier<IVariableFacade> var1, ItemStack var2, Tag var3, NBTPath var4, byte var5, BlockState var6);

    public Component getDescription(boolean highlighted) {
        return Component.m_237110_((String)("integratednbt:nbt_extractor.output_mode." + this.translationId + ".description"), (Object[])new Object[]{this.getName()}).m_6270_(highlighted ? Style.f_131099_.m_131140_(ChatFormatting.GRAY) : Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY));
    }

    public Component getName() {
        return Component.m_237115_((String)("integratednbt:nbt_extractor.output_mode." + this.translationId + ".name")).m_6270_(Style.f_131099_.m_131140_(this.color));
    }

    private static class Nest {
        private static final Texture GUI_TEXTURE = new Texture("integratednbt", "textures/gui/nbt_extractor.png");
        private static final int BUTTON_SIZE = 12;

        private Nest() {
        }
    }
}

