/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumCrystalBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumElvisBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumFoliageBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumShellBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.PartialBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SlimBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SlimyBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SmallBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.ThiccBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.TinyBeeModel;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.ModelUtils;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ProductiveBeeModel<T extends ProductiveBee>
extends AgeableListModel<T> {
    protected float FAKE_PI = (float)Math.PI;
    public static final String BONE = "bone";
    public static final String BODY = "body";
    public static final String STINGER = "stinger";
    public static final String LEFT_ANTENNA = "left_antenna";
    public static final String RIGHT_ANTENNA = "right_antenna";
    public static final String RIGHT_WING = "right_wing";
    public static final String LEFT_WING = "left_wing";
    public static final String FRONT_LEGS = "front_legs";
    public static final String MIDDLE_LEGS = "middle_legs";
    public static final String BACK_LEGS = "back_legs";
    public static final String EXTERNALS = "externals";
    public static final String INNARDS = "innards";
    public static final String SANTA_HAT = "santa_hat";
    protected ModelPart bone;
    protected ModelPart body;
    protected ModelPart rightWing;
    protected ModelPart leftWing;
    protected ModelPart frontLegs;
    protected ModelPart middleLegs;
    protected ModelPart backLegs;
    protected ModelPart stinger;
    protected ModelPart leftAntenna;
    protected ModelPart rightAntenna;
    protected ModelPart externals;
    protected ModelPart innards;
    protected ModelPart santaHat;
    protected PartialBeeModel partialModel;
    protected float rollAmount;
    public float beeSize = 1.0f;

    public ProductiveBeeModel(ModelPart modelPart) {
        this(modelPart, false, 24.0f, 0.0f);
    }

    public ProductiveBeeModel(ModelPart modelPart, boolean isChildHeadScaled, float childHeadOffsetY, float childHeadOffsetZ) {
        super(isChildHeadScaled, childHeadOffsetY, childHeadOffsetZ);
        this.bone = modelPart.m_171324_(BONE);
        this.body = this.bone.m_171324_(BODY);
        this.stinger = this.body.m_171324_(STINGER);
        this.leftAntenna = this.body.m_171324_(LEFT_ANTENNA);
        this.rightAntenna = this.body.m_171324_(RIGHT_ANTENNA);
        this.rightWing = this.bone.m_171324_(RIGHT_WING);
        this.leftWing = this.bone.m_171324_(LEFT_WING);
        this.frontLegs = this.bone.m_171324_(FRONT_LEGS);
        this.middleLegs = this.bone.m_171324_(MIDDLE_LEGS);
        this.backLegs = this.bone.m_171324_(BACK_LEGS);
        this.externals = this.body.m_171324_(EXTERNALS);
        this.innards = this.body.m_171324_(INNARDS);
        this.santaHat = this.body.m_171324_(SANTA_HAT);
    }

    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)ProductiveBeeModel.createMeshDefinition(), (int)64, (int)64);
    }

    protected static MeshDefinition createMeshDefinition() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.m_171576_();
        PartDefinition bone = root.m_171599_(BONE, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition body = bone.m_171599_(BODY, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        body.m_171599_(STINGER, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        body.m_171599_(LEFT_ANTENNA, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        body.m_171599_(RIGHT_ANTENNA, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        bone.m_171599_(RIGHT_WING, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        bone.m_171599_(LEFT_WING, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        bone.m_171599_(FRONT_LEGS, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        bone.m_171599_(MIDDLE_LEGS, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        bone.m_171599_(BACK_LEGS, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        body.m_171599_(INNARDS, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        body.m_171599_(EXTERNALS, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        body.m_171599_(SANTA_HAT, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        return meshDefinition;
    }

    public ProductiveBeeModel(ModelPart modelPart, String modelType) {
        this(modelPart, false, 24.0f, 0.0f);
        this.partialModel = switch (modelType) {
            case "thicc" -> new ThiccBeeModel(modelPart);
            case "small" -> new SmallBeeModel(modelPart);
            case "slim" -> new SlimBeeModel(modelPart);
            case "tiny" -> new TinyBeeModel(modelPart);
            case "elvis" -> new MediumElvisBeeModel(modelPart);
            case "default_shell" -> new MediumShellBeeModel(modelPart);
            case "default_foliage" -> new MediumFoliageBeeModel(modelPart);
            case "default_crystal" -> new MediumCrystalBeeModel(modelPart);
            case "translucent_with_center" -> new SlimyBeeModel(modelPart);
            default -> new MediumBeeModel(modelPart);
        };
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        super.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        this.rollAmount = entity.m_27935_(partialTicks);
        boolean bl = this.stinger.f_104207_ = !entity.m_27857_();
        if (entity instanceof ConfigurableBee && ((ConfigurableBee)entity).isStingless()) {
            this.stinger.f_104207_ = false;
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean grounded;
        this.leftAntenna.f_104203_ = 0.0f;
        this.rightAntenna.f_104203_ = 0.0f;
        this.bone.f_104203_ = 0.0f;
        this.bone.f_104201_ = 19.0f;
        boolean bl = grounded = entity.m_20096_() && entity.m_20184_().m_82556_() < 1.0E-7;
        if (grounded) {
            this.setRotationAngle(this.rightWing, 0.0f, -0.2618f, 0.0f);
            this.setRotationAngle(this.leftWing, 0.0f, 0.2618f, 0.0f);
            this.frontLegs.f_104203_ = 0.0f;
            this.middleLegs.f_104203_ = 0.0f;
            this.backLegs.f_104203_ = 0.0f;
        } else {
            this.setRotationAngle(this.rightWing, 0.0f, 0.0f, Mth.m_14089_((float)(ageInTicks % 98000.0f * 2.1f)) * this.FAKE_PI * 0.15f);
            this.setRotationAngle(this.leftWing, this.rightWing.f_104203_, this.rightWing.f_104204_, -this.rightWing.f_104205_);
            this.frontLegs.f_104203_ = 0.7853982f;
            this.middleLegs.f_104203_ = 0.7853982f;
            this.backLegs.f_104203_ = 0.7853982f;
            this.setRotationAngle(this.bone, 0.0f, 0.0f, 0.0f);
        }
        if (!((ProductiveBee)((Object)entity)).m_21660_()) {
            this.bone.f_104203_ = 0.0f;
            this.bone.f_104204_ = 0.0f;
            this.bone.f_104205_ = 0.0f;
            if (!grounded) {
                float angle = Mth.m_14089_((float)(ageInTicks * 0.18f));
                this.bone.f_104203_ = 0.1f + angle * this.FAKE_PI * 0.025f;
                this.leftAntenna.f_104203_ = angle * this.FAKE_PI * 0.03f;
                this.rightAntenna.f_104203_ = angle * this.FAKE_PI * 0.03f;
                this.frontLegs.f_104203_ = -angle * this.FAKE_PI * 0.1f + 0.3926991f;
                if (!((ProductiveBee)((Object)entity)).getRenderer().equals("thicc")) {
                    this.backLegs.f_104203_ = -angle * this.FAKE_PI * 0.05f + 0.7853982f;
                }
                this.bone.f_104201_ = 19.0f - angle * 0.9f;
            }
        }
        if (this.rollAmount > 0.0f) {
            this.bone.f_104203_ = ModelUtils.m_103125_((float)this.bone.f_104203_, (float)3.0915928f, (float)this.rollAmount);
        }
        this.beeSize = ((ProductiveBee)((Object)entity)).getSizeModifier();
        if (this.f_102610_) {
            this.beeSize /= 2.0f;
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.bone);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer renderBuffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, 1.5 - (double)this.beeSize * 1.5, 0.0);
        matrixStackIn.m_85841_(this.beeSize, this.beeSize, this.beeSize);
        super.m_7695_(matrixStackIn, renderBuffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrixStackIn.m_85849_();
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

