/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class BlockConversionRecipe
implements Recipe<Container> {
    public final ResourceLocation id;
    public final List<Lazy<BeeIngredient>> bees;
    public Ingredient input;
    public final BlockState stateFrom;
    public final BlockState stateTo;
    public final int chance;
    public Ingredient fromDisplay;
    public Ingredient toDisplay;
    public boolean pollinates;

    public BlockConversionRecipe(ResourceLocation id, List<Lazy<BeeIngredient>> bees, Ingredient input, BlockState from, BlockState to, int chance, Ingredient fromDisplay, Ingredient toDisplay, boolean pollinates) {
        this.id = id;
        this.bees = bees;
        this.input = input;
        this.stateFrom = from;
        this.stateTo = to;
        this.chance = chance;
        this.fromDisplay = fromDisplay;
        this.toDisplay = toDisplay;
        this.pollinates = pollinates;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (inv instanceof BeeHelper.BlockStateInventory && this.bees.size() > 0) {
            String beeName = ((BeeHelper.BlockStateInventory)inv).getIdentifier(0);
            BlockState blockState = ((BeeHelper.BlockStateInventory)inv).getState();
            boolean matchesBlock = !this.input.m_43947_() ? !blockState.m_60734_().equals(this.stateTo.m_60734_()) && this.input.test(new ItemStack((ItemLike)blockState.m_60734_())) : blockState.equals(this.stateFrom) || blockState.m_60734_().m_49966_().equals(this.stateFrom);
            boolean matchesBee = false;
            for (Lazy<BeeIngredient> bee : this.bees) {
                matchesBee = matchesBee || ((BeeIngredient)bee.get()).getBeeType().toString().equals(beeName);
            }
            return matchesBee && matchesBlock;
        }
        return false;
    }

    @Nonnull
    public ItemStack m_5874_(Container inv) {
        return ItemStack.f_41583_;
    }

    public List<BeeIngredient> getBees() {
        ArrayList<BeeIngredient> list = new ArrayList<BeeIngredient>();
        this.bees.forEach(bee -> list.add((BeeIngredient)bee.get()));
        return list;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.BLOCK_CONVERSION.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.BLOCK_CONVERSION_TYPE.get();
    }

    private static BlockState jsonToBlockState(JsonObject json) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Name", GsonHelper.m_13906_((JsonObject)json, (String)"Name"));
        if (json.has("Properties")) {
            CompoundTag propertyTag = new CompoundTag();
            JsonObject properties = GsonHelper.m_13930_((JsonObject)json, (String)"Properties");
            for (Map.Entry entry : properties.entrySet()) {
                propertyTag.m_128359_((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            tag.m_128365_("Properties", (Tag)propertyTag);
        }
        return NbtUtils.m_129241_((CompoundTag)tag);
    }

    public static class Serializer<T extends BlockConversionRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            ArrayList<Lazy<BeeIngredient>> bees = new ArrayList<Lazy<BeeIngredient>>();
            if (json.has("bee")) {
                String source = GsonHelper.m_13906_((JsonObject)json, (String)"bee");
                Lazy sourceBee = Lazy.of(BeeIngredientFactory.getIngredient(source));
                bees.add(sourceBee);
            } else if (json.has("bees")) {
                JsonArray beeArray = GsonHelper.m_13933_((JsonObject)json, (String)"bees");
                beeArray.forEach(jsonElement -> {
                    Lazy sourceBee = Lazy.of(BeeIngredientFactory.getIngredient(jsonElement.getAsString()));
                    bees.add(sourceBee);
                });
            }
            Ingredient input = Ingredient.f_43901_;
            BlockState from = Blocks.f_50016_.m_49966_();
            if (json.has("from")) {
                from = BlockConversionRecipe.jsonToBlockState(json.getAsJsonObject("from"));
            } else {
                input = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("input"));
            }
            BlockState to = BlockConversionRecipe.jsonToBlockState(json.getAsJsonObject("to"));
            Ingredient fromDisplay = json.has("from_display") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"from_display")) : Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)from.m_60734_().m_5456_())});
            Ingredient toDisplay = json.has("to_display") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"to_display")) : Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)to.m_60734_().m_5456_())});
            int chance = GsonHelper.m_13824_((JsonObject)json, (String)"chance", (int)100);
            boolean pollinates = GsonHelper.m_13855_((JsonObject)json, (String)"pollinates", (boolean)false);
            return this.factory.create(id, bees, input, from, to, chance, fromDisplay, toDisplay, pollinates);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                int beeCount = buffer.readInt();
                ArrayList<Lazy<BeeIngredient>> bees = new ArrayList<Lazy<BeeIngredient>>();
                for (int i = 0; i < beeCount; ++i) {
                    BeeIngredient source = BeeIngredient.fromNetwork(buffer);
                    bees.add(Lazy.of(() -> source));
                }
                Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                BlockState from = NbtUtils.m_129241_((CompoundTag)buffer.m_130261_());
                BlockState to = NbtUtils.m_129241_((CompoundTag)buffer.m_130261_());
                return this.factory.create(id, bees, input, from, to, buffer.readInt(), Ingredient.m_43940_((FriendlyByteBuf)buffer), Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readBoolean());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading block conversion recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                buffer.writeInt(((BlockConversionRecipe)recipe).bees.size());
                ((BlockConversionRecipe)recipe).bees.forEach(bee -> ((BeeIngredient)bee.get()).toNetwork(buffer));
                ((BlockConversionRecipe)recipe).input.m_43923_(buffer);
                buffer.m_130079_(NbtUtils.m_129202_((BlockState)((BlockConversionRecipe)recipe).stateFrom));
                buffer.m_130079_(NbtUtils.m_129202_((BlockState)((BlockConversionRecipe)recipe).stateTo));
                buffer.writeInt(((BlockConversionRecipe)recipe).chance);
                ((BlockConversionRecipe)recipe).fromDisplay.m_43923_(buffer);
                ((BlockConversionRecipe)recipe).toDisplay.m_43923_(buffer);
                buffer.writeBoolean(((BlockConversionRecipe)recipe).pollinates);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing block conversion recipe to packet. " + ((BlockConversionRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BlockConversionRecipe> {
            public T create(ResourceLocation var1, List<Lazy<BeeIngredient>> var2, Ingredient var3, BlockState var4, BlockState var5, int var6, Ingredient var7, Ingredient var8, boolean var9);
        }
    }
}

